<?php $__env->startSection('title', __('messages.news')); ?>
<?php $__env->startSection('body-class', 'blog'); ?>
<?php $__env->startSection('extra-css'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


        <!-- Main Contents -->
        <div id="main-contents" class="main-contents">
            <div class="main-contents-inner">

                <!-- Page Header -->
                <div class="page-header" style="background-image: url(<?php echo e(url('')); ?>/images/shop/page-header-min.jpg); background-attachment: fixed; background-repeat: no-repeat; background-position: center top; background-size: cover;">
                    <div class="page-header-inner">
                        <div class="page-header-entry">
                            <h1 class="page-title"><span><?php echo e(__('messages.news')); ?></span></h1>
                            <div class="breadcrumb"><a href="<?php echo e(route('news')); ?>"><?php echo e(__('messages.news')); ?></a></div>
                        </div>
                    </div>
                    <div class="section-radius section-radius-bottom"></div>
                </div><!-- End Page Header -->

                <!-- Page Content -->
				<div class="page-content">
					<div class="page-content-inner">

						<div class="container">
							<!-- Row -->
							<div class="row">

                                <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news_single): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!-- Post -->
								<article class="col-xs-6 col-sm-4 post">
									<!-- Entry -->
									<div class="entry">
										<figure class="entry-thumbnail">
											<a href="<?php echo e(route('news.show', ['slug' => $news_single->slug])); ?>"><img alt="" src="<?php echo e(newsImagecrop($news_single->image)); ?>"></a>
											<figcaption>
												<div class="entry-date"><?php echo e($news_single->created_at->format('M')); ?> <span class="entry-date-number"><?php echo e($news_single->created_at->format('d')); ?></span></div>
											</figcaption>
										</figure>
										<div class="entry-body">
											<h4 class="entry-title height-one"><a href="<?php echo e(route('news.show', ['slug' => $news_single->slug])); ?>"><?php echo e($news_single->getTranslatedAttribute('title', $locale, $fall_back_locale)); ?></a></h4>
											<div class="entry-content height-one"><?php echo e($news_single->getTranslatedAttribute('excerpt', $locale, $fall_back_locale)); ?>.</div>
											<div class="buttons"><a href="<?php echo e(route('news.show', ['slug' => $news_single->slug])); ?>" class="button readmore"><?php echo e(__('messages.read_more')); ?></a></div>
										</div>
									</div><!-- End Entry -->
                                </article>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                            </div>
                            <div class="text-center">
                                <?php echo e($news->links()); ?>

                            </div>


							

						</div>

					</div><!-- End Inner -->
				</div><!-- End Page Content -->

            </div><!-- End Inner -->
        </div><!-- End Main Contents -->




<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>