<?php $__env->startSection('content'); ?>




<section class="padding-y-100 bg-light">
  <div class="container">
    <div class="row">
      <div class="col-lg-6 mx-auto">
        <div class="card shadow-v2"> 
         <div class="card-header border-bottom">
          <h4 class="mt-4">
            <?php echo e(__('messages.login')); ?>

          </h4>
         </div>         
          <div class="card-body">
            <form method="POST" action="<?php echo e(route('login')); ?>" aria-label="<?php echo e(__('messages.login')); ?>" class="px-lg-4">
                 <?php echo csrf_field(); ?>


              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-email"></span>
                </div>
                <input id="email" type="email" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>"  class="form-control border-left-0 pl-0" placeholder="<?php echo e(__('messages.mail')); ?>" required autofocus>
                <?php if($errors->has('email')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('email')); ?></strong>
                    </span>
                <?php endif; ?>
              </div>


              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-lock"></span>
                </div>
                <input id="password" type="password" class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" name="password"  class="form-control border-left-0 pl-0" placeholder="<?php echo e(__('messages.password')); ?>" required>
                <?php if($errors->has('password')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('password')); ?></strong>
                    </span>
                <?php endif; ?>
              </div>


              <div class="d-md-flex justify-content-between my-4">
                <label class="ec-checkbox check-sm my-2 clearfix">
                  <input type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                  <span class="ec-checkbox__control"></span>
                  <span class="ec-checkbox__lebel"><?php echo e(__('messages.remember')); ?></span>
                </label>
                <a href="<?php echo e(route('password.request')); ?>" class="text-primary my-2 d-block"><?php echo e(__('messages.forget_password')); ?></a>
              </div>


              <button class="btn btn-block btn-primary" type="submit"><?php echo e(__('messages.login')); ?></button>
              <p class="my-5 text-center">
                 <?php echo e(__('messages.register_text')); ?> <a href="<?php echo e(route('register')); ?>" class="text-primary"><?php echo e(__('messages.register')); ?></a>
              </p>


            </form>
          </div>
        </div>
      </div> 
    </div> <!-- END row-->
  </div> <!-- END container-->
</section>

















<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>