<?php $__env->startSection('title', __('messages.events')); ?>
<?php $__env->startSection('body-class', ''); ?>
<?php $__env->startSection('extra-css'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


<div class="padding-y-80 bg-cover" data-dark-overlay="6" style="background:url(<?php echo e(url('')); ?>/assets/img/breadcrumb-bg.jpg) no-repeat">
  <div class="container">
    <h2 class="text-white">
        <?php echo e(__('messages.events')); ?>

    </h2>
    <ol class="breadcrumb breadcrumb-double-angle text-white bg-transparent p-0">
      <li class="breadcrumb-item"><a href="/"><?php echo e(__('messages.home')); ?></a></li>
      <li class="breadcrumb-item"><?php echo e(__('messages.events')); ?></li>
    </ol>
  </div>
</div>


    <section class="padding-y-60 bg-light">
        <div class="container">



              <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="list-card align-items-center shadow-v2 px-3">
                <div class="col-lg-4 py-4">
                    <img class="w-100" src="<?php echo e(newsImagecrop($event->image)); ?>" alt="">
                </div>
                <div class="col-lg-8 py-4">
                    <a href="<?php echo e(route('events.show', ['slug' => $event->slug])); ?>" class="h4">
                       <?php echo e($event->getTranslatedAttribute('title', $locale, $fall_back_locale)); ?>

                    </a>
                    <ul class="list-inline text-gray mt-3">
                        <li class="list-inline-item mr-2">
                            <i class="ti-time text-primary mr-1"></i> <?php echo e($event->date); ?>

                        </li>
                        <li class="list-inline-item mr-2">
                            <i class="ti-location-pin text-primary mr-1"></i>  <?php echo e($event->getTranslatedAttribute('address', $locale, $fall_back_locale)); ?>

                        </li>
                    </ul>

                    <ul class="list-inline mt-4" data-countdown="<?=str_replace('-', '/', $event->date)?>">
                        <li class="list-inline-item iconbox iconbox-xxxl border border-light mb-2">
                            <h2 class="countdown-days mb-0 text-primary"></h2>
                            <span><?php echo e(__('messages.days')); ?></span>
                        </li>
                        <li class="list-inline-item iconbox iconbox-xxxl border border-light mb-2">
                            <h2 class="countdown-hours mb-0 text-primary"></h2>
                            <span><?php echo e(__('messages.hours')); ?></span>
                        </li>
                        <li class="list-inline-item iconbox iconbox-xxxl border border-light mb-2">
                            <h2 class="countdown-minutes mb-0 text-primary"></h2>
                            <span><?php echo e(__('messages.minutes')); ?></span>
                        </li>
                        <li class="list-inline-item iconbox iconbox-xxxl border border-light mb-2">
                            <h2 class="countdown-seconds mb-0 text-primary"></h2>
                            <span><?php echo e(__('messages.second')); ?></span>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- END card-list-->
            <br>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



            <div class="row">

                <div class="col-12 marginTop-80">
                    <ul class="pagination pagination-primary justify-content-center">
                        <?php echo e($events->links()); ?>

                    </ul>
                </div>
            </div>
            <!-- END row-->
        </div>
        <!-- END container-->
    </section>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>