<?php $__env->startSection('title', __('messages.shop')); ?>
<?php $__env->startSection('body-class', 'woocommerce'); ?>
<?php $__env->startSection('extra-css'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

     <div class="container">
        <?php if(session()->has('success_message')): ?>
        <br><br>
            <div class="alert alert-success">
                <?php echo e(session()->get('success_message')); ?>

            </div>
        <?php endif; ?>

        <?php if(count($errors) > 0): ?>
        <br><br>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>

        <!-- Main Contents -->
        <div id="main-contents" class="main-contents">
            <div class="main-contents-inner">

                <!-- Page Header -->
                <div class="page-header" style="background-image: url(<?php echo e(url('')); ?>/images/shop/page-header-min.jpg); background-attachment: fixed; background-repeat: no-repeat; background-position: center top; background-size: cover;">
                    <div class="page-header-inner">
                        <div class="page-header-entry">
                            <h1 class="page-title"><span><?php echo e($categoryName); ?></span></h1>
                            <div class="breadcrumb"><a href="<?php echo e(route('shop')); ?>"><?php echo e(__('messages.shop')); ?></a>  /  <span><?php echo e($categoryName); ?></span></div>
                        </div>
                    </div>
                    <div class="section-radius section-radius-bottom"></div>
                </div><!-- End Page Header -->

                <!-- Page Content -->
                <div class="page-content">
                    <div class="page-content-inner">

                        <div class="shop-about">
                            <div class="container">
                                <!-- Row -->
                                <div class="row">
                                    <div class="col-sm-7">
                                        <!-- Entry -->
                                        <div class="entry">
                                            <div class="entry-body">
                                                <h2 class="entry-title">Natural Dog Food<br>plus Vitamins &amp; Minerals</h2>
                                                <div class="entry-content">
                                                    <p>A whole line of protein-rich natural dog food made from recognizable ingredients and crafted into recipes that deliver the nourishment your dog needs.</p>
                                                    <ul>
                                                        <li>CONTAINS REAL BEEF</li>
                                                        <li><strong>NO</strong> CORN, WHEAT OR SOY</li>
                                                        <li><strong>NO</strong> POULTRY BY-PRODUCT MEAL</li>
                                                        <li><strong>NO</strong> ADDED ARTIFICIAL COLORS, FLAVORS OR PRESERVATIVES</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div><!-- End Entry -->
                                    </div><!--End Col -->
                                    <div class="col-sm-5">
                                        <figure class="entry-thumbanil">
                                            <img alt="" src="<?php echo e(url('')); ?>/images/shop/img-1-min.png">
                                        </figure>
                                    </div><!--End Col -->
                                </div><!-- End Row -->

                            </div>
                        </div>
                        <div class="products">
                            <div class="filter">
                                <div class="container">
                                    <ul class="buttons">
                                        <li><a class="<?php echo e($categoryName == __('messages.featured')  ? 'active' : ''); ?> button"  href="<?php echo e(route('shop')); ?>" data-filter="*"><?php echo e(__('messages.all_categories')); ?></a></li>
                                        <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a class="<?php echo e(setActiveCategory($category->slug)); ?> button"  href="<?php echo e(route('shop', ['category' => $category->slug])); ?>" data-filter=""><?php echo e($category->getTranslatedAttribute('name', $locale, $fall_back_locale)); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </ul>

                                    <div class="filter-type">
                                        <strong><?php echo e(__('messages.price')); ?> : </strong>
                                        <a href="<?php echo e(route('shop', ['category'=> request()->category, 'sort' => 'low_high'])); ?>"><?php echo e(__('messages.low_to_high')); ?></a>
                                        /
                                        <a href="<?php echo e(route('shop', ['category'=> request()->category, 'sort' => 'high_low'])); ?>"><?php echo e(__('messages.high_to_low')); ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="products-content">
                                <div class="container">

                                    <!-- Row -->
                                    <div class="row">
                                        <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <!-- Product -->
                                        <div class="col-xs-6 col-sm-4 product">
                                            <!-- Entry -->
                                            <div class="entry">
                                                <figure class="entry-thumbnail">
                                                    <a href="<?php echo e(route('shop.show', $product->slug)); ?>"><img alt="" src="<?php echo e(productImage($product->image)); ?>"></a>
                                                </figure>
                                                <div class="entry-body">
                                                    <h3 class="entry-title"><a href="<?php echo e(route('shop.show', $product->slug)); ?>"><?php echo e($product->getTranslatedAttribute('name', $locale, $fall_back_locale)); ?></a></h3>

                                                    <span class="price">
                                                        <ins><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol"></span><?php echo e($product->presentPrice()); ?></span></ins>
                                                        <del><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol"></span><?php echo e($product->presentPrice2()); ?></span></del>
                                                    </span>

                                                    <form enctype="multipart/form-data" action="<?php echo e(route('cart.store')); ?>" method="POST" class="cart">

                                                             <?php echo e(csrf_field()); ?>

                                                            <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
                                                            <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                                            <input type="hidden" name="price" value="<?php echo e($product->price); ?>">
                                                            <div class="buttons">
                                                                <button class="button add_to_cart_button"  type="submit">Add to cart</button>

                                                            </div>

                                                </form>


                                                </div>
                                            </div><!-- End Entry -->
                                        </div><!--End Col -->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="loadmore"><a href="<?php echo e(route('shop')); ?>"> <?php echo e(__('messages.no_items_found')); ?> </a></div>
                                        <?php endif; ?>
                                        <!-- <div class="clearfix"></div> -->
                                        <div class="col-md-12 text-center center">
                                        <?php echo e($products->appends(request()->input())->links()); ?>

                                        </div>




                                    </div><!-- End Row -->

                                    <!-- <div class="loadmore"><a href="#">/ See more /</a></div> -->
                                </div>
                            </div>

                        </div>

                        <div class="section-custom-1 section" style="background-image: url(<?php echo e(url('')); ?>/images/bg-3-min.jpg); background-position: center bottom; background-repeat: no-repeat; background-attachment: fixed; background-size: cover;">
                            <div class="section-radius"></div>
                            <div class="container">
                                <div class="section-header">
                                    <h2 class="section-title f-color"><span><?php echo e(__('messages.pets')); ?></span></h2>
                                    <div class="section-subtitle"><?php echo e(__('messages.pets-text')); ?></div>
                                </div>
                                <div class="section-content">
                                    <a href="<?php echo e(route('shop', 'category=dog')); ?>" class="dog"><img alt="" src="<?php echo e(url('')); ?>/images/shop/img-2-min.png"></a>
                                    <a href="<?php echo e(route('shop', 'category=cat')); ?>" class="cat"><img alt="" src="<?php echo e(url('')); ?>/images/shop/img-3-min.png"></a>
                                </div>
                                
                            </div>
                        </div>

                          <?php echo $__env->make('mightlike', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                    </div><!-- End Inner -->
                </div><!-- End Page Content -->

            </div><!-- End Inner -->
        </div><!-- End Main Contents -->




<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>