<?php $__env->startSection('title', 'Search Results'); ?>
<?php $__env->startSection('body-class', 'woocommerce'); ?>
<?php $__env->startSection('extra-css'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


     <div class="container">
        <?php if(session()->has('success_message')): ?>
        <br><br>
            <div class="alert alert-success">
                <?php echo e(session()->get('success_message')); ?>

            </div>
        <?php endif; ?>

        <?php if(count($errors) > 0): ?>
        <br><br>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>


        <!-- Main Contents -->
        <div id="main-contents" class="main-contents">
            <div class="main-contents-inner">

                <!-- Page Header -->
                <div class="page-header" style="background-image: url(<?php echo e(url('')); ?>/images/shop/page-header-min.jpg); background-attachment: fixed; background-repeat: no-repeat; background-position: center top; background-size: cover;">
                    <div class="page-header-inner">
                        <div class="page-header-entry">
                            <h1 class="page-title"><span>Search</span></h1>
                            <div class="breadcrumb"><a href="/">Home</a>  /  <span>Search</span></div>
                        </div>
                    </div>
                    <div class="section-radius section-radius-bottom"></div>
                </div><!-- End Page Header -->

            
                <!-- Page Content -->
                <div class="page-content">
                    <div class="page-content-inner">
                        











    <div class="search-results-container container">
        <h1>Search Results</h1>
        <p class="search-results-count"><?php echo e($products->total()); ?> result(s) for '<?php echo e(request()->input('query')); ?>'</p>

        <?php if($products->total() > 0): ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Details</th>
                    <th>Description</th>
                    <th>Price</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th><a href="<?php echo e(route('shop.show', $product->slug)); ?>"><?php echo e($product->name); ?></a></th>
                        <td><?php echo e($product->details); ?></td>
                        <td><?php echo e(str_limit($product->description, 80)); ?></td>
                        <td><?php echo e($product->presentPrice()); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php echo e($products->appends(request()->input())->links()); ?>

        <?php endif; ?>
    </div> <!-- end search-results-container -->











                        
                    </div><!-- End Inner -->
                </div><!-- End Page Content -->
            
            </div><!-- End Inner -->
        </div><!-- End Main Contents -->



<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>