<!doctype html>
<?php
   $rtl = '';
   if (App::isLocale('ar') || App::isLocale('he')) {
       $rtl = '-rtl';
   }
?>
<html lang="<?php echo e(app()->getLocale()); ?>">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <!-- viewport scale-->
         <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo $__env->yieldContent('title', ''); ?></title>
        <!-- SEO Meta-->
        <meta name="description" content="">
        <meta name="keywords" content="">
        <meta name="author" content="sirreya">

        <link href="<?php echo e(url('')); ?>/assets/img/favicon/favicon.ico" rel="SHORTCUT ICON" />


         <!-- Bootstrap core CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/bootstrap.min.css" rel="stylesheet">
     <?php
         if (App::isLocale('ar') || App::isLocale('he'))
         {
        ?>
        <link rel="stylesheet" href="<?php echo e(asset("assets/css/bootstrap{$rtl}.css")); ?>">
        <?php
        }
        ?>
    <!-- Bx-Slider StyleSheet CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/jquery.bxslider.css" rel="stylesheet">
    <!-- Font Awesome StyleSheet CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/font-awesome.css" rel="stylesheet">
    <link href="<?php echo e(url('')); ?>/assets/css/svg-style.css" rel="stylesheet">
    <!-- Pretty Photo CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/prettyPhoto.css" rel="stylesheet">

    <!-- DL Menu CSS -->
    <link href="<?php echo e(url('')); ?>/assets/js/dl-menu/component.css" rel="stylesheet">
    <!-- Typography CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/typography.css" rel="stylesheet">
    <!-- Animation CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/animate.css" rel="stylesheet">
    <!-- Owl Carousel CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/owl.carousel.css" rel="stylesheet">
    <!-- Color CSS -->
    <link href="<?php echo e(url('')); ?>/assets/css/color.css" rel="stylesheet">
    <!-- Widget CSS -->
    <link href="<?php echo e(asset("assets/css/widget{$rtl}.css")); ?>" rel="stylesheet">
    <!-- Shortcodes CSS -->
    <link href="<?php echo e(asset("assets/css/shortcodes{$rtl}.css")); ?>" rel="stylesheet">
    <!-- Custom Main StyleSheet CSS -->
    <link href="<?php echo e(asset("assets/css/style{$rtl}.css")); ?>" rel="stylesheet">
    <!-- Responsive CSS -->
    <link href="<?php echo e(asset("assets/css/responsive{$rtl}.css")); ?>" rel="stylesheet">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.css" media="screen">



        <?php echo $__env->yieldContent('extra-css'); ?>
    </head>


<body class="<?php echo $__env->yieldContent('body-class', ''); ?>">
    <!--Wrapper Start-->
    <div class="ct_wrapper">

    <?php echo $__env->make('header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    </div>
    <!--Wrapper End-->


     <!--Bootstrap core JavaScript-->
    <script src="<?php echo e(url('')); ?>/assets/js/jquery.js"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/bootstrap.min.js"></script>
    <!--Bx-Slider JavaScript-->
    <script src="<?php echo e(url('')); ?>/assets/js/jquery.bxslider.min.js"></script>
    <!--Dl Menu Script-->
    <script src="<?php echo e(url('')); ?>/assets/js/dl-menu/modernizr.custom.js"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/dl-menu/jquery.dlmenu.js"></script>
    <!--Owl Carousel JavaScript-->
    <script src="<?php echo e(url('')); ?>/assets/js/owl.carousel.js"></script>
    <!--Time Counter Javascript-->
    <script src="<?php echo e(url('')); ?>/assets/js/jquery.downCount.js"></script>
    <!--Pretty Photo Javascript-->
    <script src="<?php echo e(url('')); ?>/assets/js/jquery.prettyPhoto.js"></script>
    <!--Way Points Javascript-->
    <script src="<?php echo e(url('')); ?>/assets/js/waypoints-min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.js"></script>
    <!--Custom JavaScript-->
    <script src="<?php echo e(url('')); ?>/assets/js/custom.js"></script>

    

    <script type="text/javascript">
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
    </script>

     <?php echo $__env->yieldContent('extra-js'); ?>

</body>
</html>
