<?php $__env->startSection('title', __('messages.contact')); ?>
<?php $__env->startSection('body-class', 'contact'); ?>
<?php $__env->startSection('extra-css'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


<!-- Main Contents -->
		<div id="main-contents" class="main-contents">
			<div class="main-contents-inner">

				<!-- Page Header -->
				<div class="page-header" style="background-image: url(../images/shop/page-header-min.jpg); background-attachment: fixed; background-repeat: no-repeat; background-position: center top; background-size: cover;">
					<div class="page-header-inner">
						<div class="page-header-entry">
							<h1 class="page-title"><span><?php echo e(__('messages.contact')); ?></span></h1>
						</div>
					</div>
					<div class="section-radius section-radius-bottom"></div>
				</div><!-- End Page Header -->

				<!-- Page Content -->
				<div class="page-content">
					<div class="page-content-inner">

						<div class="container">
							<div class="contact-form">
								<!-- Section Header -->
								<div class="section-header style-v2">
									<h2 class="section-title"><span><?php echo e(__('messages.contact_title')); ?></span></h2>
									<div class="section-subtitle"><?php echo e(__('messages.contact_text')); ?></div>
                                </div><!-- End Section Header -->

                                <div class="alert alert-danger print-error-msg" style="display:none">
                                <ul></ul>
                                </div>

                                <div class="alert alert-success print-msg" style="display:none">
                                <p><?php echo e(__('messages.contact_thanks')); ?></p>
                                </div>

								<form action="#" method="post" id="contactform" class="wpcf7-form form">
									<!-- Row -->
									<div class="row">
										<div class="col-xs-6 col-sm-6">
											<p class="comment-form-title">
												<input type="text" required="required" size="30" value="" name="title" id="title" placeholder="<?php echo e(__('messages.contact_title_input')); ?>">
											</p>
											<p class="comment-form-phone">
												<input type="text" required="required" size="30" value="" name="phone" id="phone" placeholder="<?php echo e(__('messages.contact_phone_input')); ?>">
											</p>
										</div>
										<div class="col-xs-6 col-sm-6">
											<p class="comment-form-name">
												<input type="text" required="required" size="30" value="" name="name" id="name" placeholder="<?php echo e(__('messages.contact_name_input')); ?>">
											</p>
											<p class="comment-form-email">
												<input type="email" required="required" size="30" value="" name="email" id="email" placeholder="<?php echo e(__('messages.contact_email_input')); ?>">
											</p>
										</div>
									</div><!-- End Row -->
									<p class="comment-form-message">
										<textarea required="required" rows="6" cols="45" name="message" id="message" placeholder="<?php echo e(__('messages.contact_message_input')); ?>"></textarea>
									</p>

									<p class="form-submit buttons">
										<button class="button btn-submit" type="submit" id="submit" name="submit"><?php echo e(__('messages.contact_submit')); ?></button>
									</p>

								</form><!-- End Form -->
							</div>
						</div><!-- End Container -->



						<div class="maps">
							<div id="map-canvas"></div>
						</div>

					</div><!-- End Inner -->
				</div><!-- End Page Content -->

			</div><!-- End Inner -->
		</div><!-- End Main Contents -->



<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDbRP9Oh0Z6hACbCfU-p6s6hyX7-6huxzU"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
<script type="text/javascript">
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(".btn-submit").click(function(e){
        e.preventDefault();

        var title = $("input[name=title]").val();
        var name = $("input[name=name]").val();
        var email = $("input[name=email]").val();
        var phone = $("input[name=phone]").val();
        var message = $("textarea[name=message]").val();

        $.ajax({
           type:'POST',
           url:'/contact',
           data:{title:title, name:name, email:email, phone:phone, message:message},
           success: function(data) {
	                if($.isEmptyObject(data.error)){
	                	printMsg(data.success);
	                }else{
	                	printErrorMsg(data.error);
	                }
	            }
        });
        function printErrorMsg (msg) {
            $(".print-msg").css('display','none');
			$(".print-error-msg").find("ul").html('');
			$(".print-error-msg").css('display','block');
			$.each( msg, function( key, value ) {
				$(".print-error-msg").find("ul").append('<li>'+value+'</li>');
			});
        }
        function printMsg (msg) {
            document.getElementById("submit").disabled = true;
            $(".print-error-msg").css('display','none');
            $(".print-msg").css('display','block');
            $("#contactform")[0].reset();
        }




	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>