<!doctype html>
<?php
   $rtl = '';
   if (App::isLocale('ar') || App::isLocale('he')) {
       $rtl = '-rtl';
   }
?>
<html lang="<?php echo e(app()->getLocale()); ?>">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo $__env->yieldContent('title', ''); ?></title>

        <link href="/img/favicon.ico" rel="SHORTCUT ICON" />

        <link href='https://fonts.googleapis.com/css?family=Dosis:400,200,300,500,600,700,800&amp;subset=latin,latin-ext' rel='stylesheet' type='text/css'>
        <link href='https://fonts.googleapis.com/css?family=Kameron:400,700' rel='stylesheet' type='text/css'>
        <link href='https://fonts.googleapis.com/css?family=Raleway:400,100,100italic,200,200italic,300,300italic,400italic,500,500italic,600,600italic,700,700italic,800,900italic,900,800italic&amp;subset=latin,latin-ext' rel='stylesheet' type='text/css'>


        <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css"/>


        <link rel="stylesheet" href="<?php echo e(url('')); ?>/assets/css/animate.css">
        <!-- Latest compiled and minified CSS -->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">

        <!-- Optional theme -->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap-theme.min.css" integrity="sha384-rHyoN1iRsVXV4nD0JutlnGaslCJuC7uwjduW9SVrLvRYooPp2bWYgmgJQIXwl/Sp" crossorigin="anonymous">

        <link rel="stylesheet" type="text/css" href="<?php echo e(asset("assets/css/bootstrap{$rtl}.min.css")); ?>">

        <link rel="stylesheet" href="<?php echo e(url('')); ?>/assets/css/font-awesome.min.css">
        <link rel="stylesheet" href="<?php echo e(url('')); ?>/assets/css/flickity.min.css">
        <link rel="stylesheet" href="<?php echo e(url('')); ?>/assets/css/nivo-slider.css">
        <link rel="stylesheet" href="<?php echo e(asset("assets/css/main{$rtl}.css")); ?>">
        <link rel="stylesheet" href="<?php echo e(asset("assets/css/responsive{$rtl}.css")); ?>">
        <link rel="stylesheet" href="<?php echo e(asset("assets/css/color/default{$rtl}.css")); ?>">

        <script src="<?php echo e(url('')); ?>/assets/js/vendor/modernizr-2.8.3-respond-1.4.2.min.js"></script>

        <?php echo $__env->yieldContent('extra-css'); ?>
    </head>


<body class="<?php echo $__env->yieldContent('body-class', ''); ?>">

    <div id="wrap">



    <?php echo $__env->make('header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    </div><!-- End Wrap -->
    <script src="<?php echo e(url('')); ?>/assets/js/vendor/jquery-1.11.2.min.js"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/vendor/imagesloaded.pkgd.min.js"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/vendor/jquery.countdown.min.js"></script>
    <!-- Latest compiled and minified JavaScript -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/vendor/flickity.pkgd.min.js"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/vendor/jquery.waypoints.min.js"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/vendor/sticky.min.js"></script>
    <script src="<?php echo e(url('')); ?>/assets/js/vendor/jquery.nivo.slider.pack.js"></script>
    <!-- <script src="https://maps.googleapis.com/maps/api/js"></script>-->

    <script type="text/javascript">
        $.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
    </script>
    <script type="text/javascript">

$(function () {
    $('a[href="#search"]').on('click', function(event) {
        event.preventDefault();
        $('#search').addClass('open');
        $('#search > form > input[type="search"]').focus();
    });

    $('#search, #search button.close').on('click keyup', function(event) {
        if (event.target == this || event.target.className == 'close' || event.keyCode == 27) {
            $(this).removeClass('open');
        }
    });


    //Do not include! This prevents the form from submitting for DEMO purposes only!
    // $('form').submit(function(event) {
    //     event.preventDefault();
    //     return false;
    // })
});
    </script>
    <script src="<?php echo e(url('')); ?>/assets/js/main.js"></script>
     <?php echo $__env->yieldContent('extra-js'); ?>
</body>
</html>
