<?php $__env->startSection('title', 'Checkout'); ?>
<?php $__env->startSection('body-class', 'woocommerce'); ?>
<?php $__env->startSection('extra-css'); ?>
<style type="text/css">

   button:disabled,
button[disabled]{
  border: 1px solid #999999;
  background-color: #cccccc;
  color: #666666;
  cursor: not-allowed;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- Main Contents -->
<div id="main-contents" class="main-contents">
   <div class="main-contents-inner">
      <!-- Page Header -->
      <div class="page-header" style="background-image: url(<?php echo e(url('')); ?>/images/shop/page-header-min.jpg); background-attachment: fixed; background-repeat: no-repeat; background-position: center top; background-size: cover;">
         <div class="page-header-inner">
            <div class="page-header-entry">
               <h1 class="page-title"><span>Checkout</span></h1>
               <div class="breadcrumb"><a href="/">Home</a>  /  <span>Checkout</span></div>
            </div>
         </div>
         <div class="section-radius section-radius-bottom"></div>
      </div>
      <!-- End Page Header -->
      <!-- Page Content -->
      <div class="page-content">
         <div class="page-content-inner">
            <div class="container">

                <?php if(session()->has('success_message')): ?>
            <div class="spacer"></div>
            <div class="alert alert-success">
                <?php echo e(session()->get('success_message')); ?>

            </div>
        <?php endif; ?>

        <?php if(count($errors) > 0): ?>
            <div class="spacer"></div>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo $error; ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>


               <div class="checkout-section">
                  <div class="col-md-6 boxxx">
                     <form action="<?php echo e(route('checkout.store')); ?>" method="POST" id="payment-form">
                        <?php echo e(csrf_field()); ?>

                        <h2>Billing Details</h2>
                        <div class="form-group">
                           <label for="email">Email Address</label>
                           <?php if(auth()->user()): ?>
                           <input type="email" class="form-control" id="email" name="email" value="<?php echo e(auth()->user()->email); ?>" readonly>
                           <?php else: ?>
                           <input type="email" class="form-control" id="email" name="email" value="<?php echo e(old('email')); ?>" required>
                           <?php endif; ?>
                        </div>
                        <div class="form-group">
                           <label for="name">Name</label>
                           <input type="text" class="form-control" id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                        </div>
                        <div class="form-group">
                           <label for="address">Address</label>
                           <input type="text" class="form-control" id="address" name="address" value="<?php echo e(old('address')); ?>" required>
                        </div>
                        <div class="half-form">
                           <div class="form-group">
                              <label for="city">City</label>
                              <input type="text" class="form-control" id="city" name="city" value="<?php echo e(old('city')); ?>" required>
                           </div>
                           <!-- <div class="form-group">
                              <label for="province">Province</label>
                              <input type="text" class="form-control" id="province" name="province" value="<?php echo e(old('province')); ?>" required>
                           </div> -->
                        </div>
                        <!-- end half-form -->
                        <div class="half-form">
                           <!-- <div class="form-group">
                              <label for="postalcode">Postal Code</label>
                              <input type="text" class="form-control" id="postalcode" name="postalcode" value="<?php echo e(old('postalcode')); ?>" required>
                           </div> -->
                           <div class="form-group">
                              <label for="phone">Phone</label>
                              <input type="text" class="form-control" id="phone" name="phone" value="<?php echo e(old('phone')); ?>" required>
                           </div>
                        </div>
                        <!-- end half-form -->
                        <div class="spacer"></div>
                       <!--  <h2>Payment Details</h2>
                        <div class="form-group">
                           <label for="name_on_card">Name on Card</label>
                           <input type="text" class="form-control" id="name_on_card" name="name_on_card" value="">
                        </div>
                        <div class="form-group">
                           <label for="card-element">
                           Credit or debit card
                           </label>
                           
                        </div> -->
                        <!-- <div class="spacer"></div> -->
                        <button type="submit" id="complete-order" class="x-1">Complete Order</button>
                     </form>
                  </div>
               </div>
               <!-- end checkout-section -->
               <div class="col-md-6">
                  <div class="boxxx">
                     <!-- Title -->
                     <div class="title">
                        Checkout <?php if(Cart::count() > 0): ?>( <?php echo e(Cart::count()); ?> item(s) in Checkout )  <?php else: ?> [No items in Cart!]  <?php endif; ?>
                     </div>
                     <?php $__currentLoopData = Cart::content(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <!-- Product #1 -->
                     <div class="item">
                        <div class="image">
                           <img src="<?php echo e(productImage($item->model->image)); ?>" alt="" width="80px" />
                        </div>
                        <div class="description">
                           <h3 class="entry-title"><a href="<?php echo e(route('shop.show', $item->model->slug)); ?>"><?php echo e($item->model->name); ?></a></h3>
                           <span><?php echo e($item->model->details); ?></span>
                        </div>

                        <div class="total-price"><?php echo e($item->model->presentPrice()); ?></div>
                     </div>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                  <?php if(Cart::count() > 0): ?>
                  <!-- Price -->
                  <div class="boxxx">
            <div class="cart-price">
              Sub Total Price :  <?php echo e(presentPrice(Cart::subtotal())); ?> <br>

               <?php if(session()->has('coupon')): ?>
                  Discount(<?php echo e(session()->get('coupon')['name']); ?>)  :  -<?php echo e(presentPrice($discount)); ?>

                  <form action="<?php echo e(route('coupon.destroy')); ?>" method="POST" style="display:inline-block;">
                      <?php echo e(csrf_field()); ?>

                      <?php echo e(method_field('delete')); ?>

                      <button type="submit" style="font-size:10px;">Remove</button>
                  </form>
                  <hr>
                    New Sub Total Price : <?php echo e(presentPrice($newSubtotal)); ?><br>
              <?php endif; ?>

              Tax + Payment service  :  <?php echo e(presentPrice($newTax)); ?><br><br>
              <h3 class="woocommerce-Price-amount amount">Total Price : <?php echo e(presentPrice($newTotal)); ?></h3>
            </div>

            <?php if(! session()->has('coupon')): ?>
            <div class="widget widget_search" style="margin: 10px;">
              <a href="<?php echo e(route('cart.index')); ?>">Do You Have Cuppon?</a>
            </div>
            <?php endif; ?>


                  </div>


                  <?php endif; ?>
               </div>
            </div>
         </div>
         <!-- End Inner -->
      </div>
      <!-- End Page Content -->
   </div>
   <!-- End Inner -->
</div>
<!-- End Main Contents -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra-js'); ?>
<script type="text/javascript">
    (function(){
           
            // Handle form submission
            var form = document.getElementById('payment-form');
            form.addEventListener('submit', function(event) {
              // event.preventDefault();

              // Disable the submit button to prevent repeated clicks
              document.getElementById('complete-order').disabled = true;


              
            });

          
        })();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>