<!doctype html>
<?php
   $rtl = '';
   if (App::isLocale('ar') || App::isLocale('he')) {
       $rtl = '-rtl';
   }
?>
<html lang="<?php echo e(app()->getLocale()); ?>">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <!-- viewport scale-->
         <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo $__env->yieldContent('title', ''); ?></title>
        <!-- SEO Meta-->
        <meta name="description" content="Academic City International School by EduSoft">
        <meta name="keywords" content="Academic City International School">
        <meta name="author" content="EduSoft">

        <link href="<?php echo e(url('')); ?>/assets/img/favicon/favicon.ico" rel="SHORTCUT ICON" />

        <!--Google fonts-->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Maven+Pro:400,500,700%7CWork+Sans:400,500">
        <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css"/>



        <!-- Icon fonts -->
        <link rel="stylesheet" href="<?php echo e(url('')); ?>/assets/fonts/fontawesome/css/all.css">
        <link rel="stylesheet" href="<?php echo e(url('')); ?>/assets/fonts/themify-icons/css/themify-icons.css">


        <!-- stylesheet-->
        <link rel="stylesheet" href="<?php echo e(url('')); ?>/assets/css/vendors.bundle.css">
        <?php
         if (App::isLocale('ar') || App::isLocale('he'))
         {
        ?>
        <link rel="stylesheet" href="<?php echo e(asset("assets/css/bootstrap{$rtl}.css")); ?>">
        <?php
        }
        ?>
        <link rel="stylesheet" href="<?php echo e(asset("assets/css/style-in{$rtl}.css")); ?>">



        <?php echo $__env->yieldContent('extra-css'); ?>
    </head>


<body class="<?php echo $__env->yieldContent('body-class', ''); ?>">


    <?php echo $__env->make('header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>


    <script src="<?php echo e(url('')); ?>/assets/js/vendors.bundle.js"></script>
    <script src="<?php echo e(asset("assets/js/scripts{$rtl}.js")); ?>"></script>

    <script type="text/javascript">
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
    </script>

     <?php echo $__env->yieldContent('extra-js'); ?>

</body>
</html>
