<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'MainPageController@index')->name('/');


// Route::get('/shop', 'ShopController@shop')->name('shop');
// Route::get('/shop/{product}', 'ShopController@show')->name('shop.show');
// Route::get('/cart', 'CartController@index')->name('cart.index');
// Route::post('/cart', 'CartController@store')->name('cart.store');
// Route::patch('/cart/{product}', 'CartController@update')->name('cart.update');
// Route::delete('/cart/{product}', 'CartController@destroy')->name('cart.destroy');
// Route::post('/coupon', 'CouponsController@store')->name('coupon.store');
// Route::delete('/coupon', 'CouponsController@destroy')->name('coupon.destroy');
// Route::get('/checkout', 'CheckoutController@index')->name('checkout.index')->middleware('auth');
// Route::post('/checkout', 'CheckoutController@store')->name('checkout.store');
// Route::get('/guestCheckout', 'CheckoutController@index')->name('guestCheckout.index');
// Route::get('/thankyou', 'ConfirmationController@index')->name('confirmation.index');

Route::get('/slider/{id}', 'MainPageController@slider_single')->name('slider_single');
Route::get('/news', 'MainPageController@news')->name('news');
Route::get('/news/{slug}', 'MainPageController@news_single')->name('news.show');

Route::get('empty', function() {
	Cart::destroy();
});

Route::get('/pages/{slug}', 'PagesController@show')->name('pages.show');

Route::get('/events', 'EventsController@index')->name('events');
Route::get('/events/{slug}', 'EventsController@show')->name('events.show');

Route::get('/faq', 'MainPageController@faq')->name('faq');

Route::get('/gallery', 'MainPageController@gallery')->name('gallery');

Route::get('/contact', 'MainPageController@contact')->name('contact');
Route::post('/contact', 'MainPageController@contactp')->name('contact');


Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();
});



Auth::routes();
Route::get('/home', 'MainPageController@index')->name('home');
// Route::get('/home', 'HomeController@index')->name('home');
Route::get('/search', 'ShopController@search')->name('search');


Route::get('lang/{lang}', ['as'=>'lang.switch', 'uses'=>'LanguageController@switchLang']);
