@extends('layout')

@section('title', $page->title)
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')

<!--Banner Wrap Start-->
        <section class="sub_banner_wrap" style="background-image: url({{ image(setting('site.pages_header_image')) }});">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="sub_banner_hdg">
                            <h3>{{ $page->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</h3>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="ct_breadcrumb">
                            <ul>
                                <li><a href="/">{{ __('messages.home') }}</a></li>
                                <li><a href="#">{{ $page->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Banner Wrap End-->

		<!--Content Wrap Start-->
        <div class="ct_content_wrap">
            <section class="ct_blog_outer_wrap">
                <div class="container">
                    <div class="row">
                        <!--Blog Detail Wrap Start-->
                        <div class="col-md-12">
                            <div class="ct_blog_detail_outer_wrap">
                                <div class="ct_blog_detail_des">
								   @if(isset($page->image))
								   <div class="col-md-6 text-center center-block center">
									<figure>
                                        <img src="{{ Image($page->image) }}" alt="">
									</figure>
									</div>
									<div class="col-md-6">
									<h4>{{ $page->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</h4>
									<p>
									{!! $page->getTranslatedAttribute('body', $locale, $fall_back_locale) !!}
									</p>
									</div>
									@else
									<div class="col-md-12">
									<h4>{{ $page->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</h4>
									<p>
									{!! $page->getTranslatedAttribute('body', $locale, $fall_back_locale) !!}
									</p>
									</div>
									@endif

                                </div>

								@if(isset($page->files))
                                <div class="ct_blog_detail_tag">
                                    <h5>{{ __('messages.files') }}</h5>
                                    <ul>
										@php
										$i=0;
										@endphp
										@foreach(json_decode($page->files) as $file)
										<li><a href="/storage/{{ json_decode($page->files)[$i]->download_link}}">{{ json_decode($page->files)[$i]->original_name}}</a></li>
										@php
										$i++;
										@endphp
										@endforeach
                                    </ul>
								</div>
								@endif
								 <div class="ct_blog_detail_des">
									@if(isset($page->pdf))
										@php
										$i=0;
										@endphp
										@foreach(json_decode($page->pdf) as $pdf_single)
											<object data="/storage/{{ json_decode($page->pdf)[$i]->download_link}}" type="application/pdf" width="100%" height="800px">
											<p>It appears you don't have a PDF plugin for this browser.
											No biggie... you can <a href="/storage/{{ json_decode($page->pdf)[$i]->download_link}}">click here to
											download the PDF file.</a></p>
											</object>
										@php
										$i++;
										@endphp
										@endforeach
									@endif
								 </div>


                            </div>
                        </div>
                        <!--Blog Detail Wrap End-->
                    </div>
                </div>
            </section>
        </div>
		<!--Content Wrap End-->


@endsection

@section('extra-js')

@endsection
