@extends('layout')

@section('title', setting('site.title') )
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')













<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
  <ol class="carousel-indicators">
    @php
      $i=0;
    @endphp
    @foreach ($sliders as $slider)
    <li data-target="#carouselExampleIndicators" data-slide-to="{{ $i }}" class=" @php if ($i==0) { echo 'active'; }  @endphp "></li>
    @php
      $i++;
    @endphp
    @endforeach
  </ol>

  <div class="carousel-inner">
  @php
      $x=0;
    @endphp
    @foreach ($sliders as $slider)
    <div class="carousel-item padding-y-80 height-90vh @php if ($x==0) { echo 'active'; }  @endphp">
     <div class="bg-absolute" data-dark-overlay="4" style="background:url({{  sliderImagecrop($slider->image) }}) no-repeat"></div>
        <div class="container">
          <div class="row">
            <div class="col-lg-10 mx-auto text-center text-white">
              <h1 class="display-lg-3 font-weight-bold animated slideInUp">
                {{ $slider->getTranslatedAttribute('title', $locale, $fall_back_locale) }}
              </h1>
              <p class="lead animated fadeInUp">
               {{ $slider->getTranslatedAttribute('sub_title', $locale, $fall_back_locale) }}
              </p>
            </div>
          </div>
        </div>
    </div>
    @php
      $x++;
    @endphp
    @endforeach

  </div>
  <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
    <i class="ti-angle-left iconbox bg-black-0_5 hover:primary"></i>
  </a>
  <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
    <i class="ti-angle-right iconbox bg-black-0_5 hover:primary"></i>
  </a>
</div>











<section class="bg-light-v2 paddingTop-80 paddingBottom-100">
  <div class="container">
    <div class="row text-center">

      @foreach ($services as $service)
      <div class="col-md-6 col-lg-4 marginTop-30">
       <a href="#" class="card shadow-v1 align-items-center p-5 hover:transformTop">
         <img src="{{ cropped_Image($service->image) }}" alt="">
         <h4 class="mt-2">
           {{ $service->getTranslatedAttribute('title', $locale, $fall_back_locale) }}
         </h4>
       </a>
      </div>
      @endforeach


    </div> <!-- END row-->
  </div> <!-- END container-->
</section>   <!-- END section-->



{{--

<section class="pt-5">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-6">
        <img src="{{url('')}}/assets/img/avatar/1_1.png" alt="">
      </div>
      <div class="col-md-6 mt-3">
        <h2>
         <small class="text-primary d-block">
           Hello, and
         </small>
          welcome to Academic City International School.
        </h2>
        <p class="lead">
          People make a university great, so whether you are a prospective student, current student, professor.
        </p>
        <p>
          Investig ationes demons trave wanrunt lectores legere liushgfy quod legunt saeph claritas nvestig ationes demons trave rugngt investiga legere liushgfy quod legunt saeph claritas nvestig ationes.
        </p>
        <h4 class="mt-2">
          CEO Name
        </h4>
        <p>
          President of Academic City International School <br>
        </p>
        <img src="{{url('')}}/assets/img/sign.png" alt="">
      </div>
    </div>
  </div>
</section>
--}}

<section class="padding-y-100" data-primary-overlay="7" style="background:url({{url('')}}/assets/img/1920/962.jpg) no-repeat">
  <div class="container">
    <div class="row">

      <div class="col-12 text-center text-white mb-md-4">
        <h2 class="mb-4">
          {{ __('messages.events') }}
        </h2>
        <div class="width-3rem height-4 rounded bg-white mx-auto"></div>
      </div>


      @foreach ($events as $event)
      <div class="col-md-4 mt-4">
        <div class="card">
          <img class="card-img-top" src="{{ newsImagecrop($event->image) }}" alt="">
          <div class="card-body">
            <h4 class="h5">
              {{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}
            </h4>
            <ul class="list-unstyled my-4 line-height-xl">
              <li>
                 <i class="ti-time mr-2 text-primary"></i>
                 {{ $event->date }} @ {{ date('G:i', strtotime($event->time)) }}
              </li>
              <li>
                 <i class="ti-location-pin mr-2 text-primary"></i>
                 {{ $event->getTranslatedAttribute('address', $locale, $fall_back_locale) }}
              </li>
            </ul>
            <a href="{{ route('events.show', ['slug' => $event->slug]) }}" class="text-primary">
              {{ __('messages.read_more') }}
              <i class="ti-angle-double-right small"></i>
            </a>
          </div>
        </div>
      </div> <!-- END col-md-4-->
      @endforeach





      <div class="col-12 mt-5 text-center">
        <a href="{{ route('events') }}" class="btn btn-outline-white-hover">{{ __('messages.events') }}</a>
      </div>
    </div> <!-- END row-->
  </div> <!-- END container-->
</section>





{{--
<section class="padding-y-100">
  <div class="container">
    <div class="row">
      <div class="col-12 text-center mb-md-4">
        <h2 class="mb-4">
          Video
        </h2>
        <div class="width-3rem height-4 rounded bg-primary mx-auto"></div>
      </div>
    </div> <!-- END row-->
    <div class="row">
      <div class="col-lg-6 marginTop-30">
        <img class="w-100" src="{{url('')}}/assets/img/555x490/1.jpg" alt="">
      </div>
      <div class="col-lg-6">
        <div class="row">
          <div class="col-md-6 marginTop-30">
            <div class="position-relative">
              <img class="w-100" src="{{url('')}}/assets/img/262x230/1.jpg" alt="">
              <a href="https://www.youtube.com/watch?v=7e90gBu4pas" data-fancybox class="position-absolute absolute-center iconbox iconbox-lg bg-white ">
              <i class="ti-control-play text-primary"></i>
            </a>
            </div>
          </div>
          <div class="col-md-6 marginTop-30">
            <div class="position-relative">
              <img class="w-100" src="{{url('')}}/assets/img/262x230/2.jpg" alt="">
              <a href="https://www.youtube.com/watch?v=7e90gBu4pas" data-fancybox class="position-absolute absolute-center iconbox iconbox-lg bg-white ">
              <i class="ti-control-play text-primary"></i>
            </a>
            </div>
          </div>
          <div class="col-md-6 marginTop-30">
            <div class="position-relative">
              <img class="w-100" src="{{url('')}}/assets/img/262x230/3.jpg" alt="">
              <a href="https://www.youtube.com/watch?v=7e90gBu4pas" data-fancybox class="position-absolute absolute-center iconbox iconbox-lg bg-white ">
              <i class="ti-control-play text-primary"></i>
            </a>
            </div>
          </div>
          <div class="col-md-6 marginTop-30">
            <div class="position-relative">
              <img class="w-100" src="{{url('')}}/assets/img/262x230/4.jpg" alt="">
              <a href="https://www.youtube.com/watch?v=7e90gBu4pas" data-fancybox class="position-absolute absolute-center iconbox iconbox-lg bg-white ">
              <i class="ti-control-play text-primary"></i>
            </a>
            </div>
          </div>
        </div>
      </div>
    </div> <!-- END row-->
  </div> <!-- END container-->
</section> --}}




{{--
<section class="paddingTop-60 paddingBottom-100" data-dark-overlay="6" style="background:url({{url('')}}/assets/img/college/2.jpg) no-repeat">
  <div class="container">
    <div class="row text-center text-white">

      <div class="col-lg-3 col-md-6 mt-5 wow zoomIn" data-wow-delay=".1">
        <h2 class="h1 text-primary">
          520
        </h2>
        <p class="lead">
          Courses
        </p>
      </div>

      <div class="col-lg-3 col-md-6 mt-5 wow zoomIn" data-wow-delay=".2">
        <h2 class="h1 text-primary">
          690
        </h2>
        <p class="lead">
          Trusted Teachers
        </p>
      </div>

      <div class="col-lg-3 col-md-6 mt-5 wow zoomIn" data-wow-delay=".3">
        <h2 class="h1 text-primary">
          235K
        </h2>
        <p class="lead">
          Students
        </p>
      </div>

      <div class="col-lg-3 col-md-6 mt-5 wow zoomIn" data-wow-delay=".4">
        <h2 class="h1 text-primary">
          150K
        </h2>
        <p class="lead">
          Success Stories
        </p>
      </div>

    </div> <!-- END row-->
  </div> <!-- END container-->
</section> --}}







<section class="bg-light-v2 padding-y-100">
  <div class="container">
    <div class="row">
      <div class="col-12 text-center mb-md-4">
        <h2 class="mb-4">
          {{ __('messages.news') }}
        </h2>
        <div class="width-3rem height-4 rounded bg-primary mx-auto"></div>
      </div>
    </div> <!-- END row-->
    <div class="row">

      @foreach ($news as $news_single)
      <div class="col-lg-4 marginTop-30">


        <div class="card">
          <img class="card-img-top" src="{{ newsImagecrop($news_single->image) }}" alt="">
          <div class="card-body">
           <p class="text-primary">
             {{ $news_single->created_at->format('d') }} {{ $news_single->created_at->format('M') }} {{ $news_single->created_at->format('Y') }}
           </p>
           <h4>
            <a href="#">
              {{ $news_single->getTranslatedAttribute('title', $locale, $fall_back_locale) }}
            </a>
           </h4>
           <p>
            {{ $news_single->getTranslatedAttribute('excerpt', $locale, $fall_back_locale) }}
           </p>
            <a href="{{ route('news.show', ['slug' => $news_single->slug]) }}" class="btn btn-outline-primary">
              {{ __('messages.read_more') }}
            </a>
          </div>
        </div>



      </div>
      @endforeach




    </div> <!-- END row-->
  </div> <!-- END container-->
</section>







{{--
<section class=" padding-y-100 bg-prim-0_9">
    <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-5 mr-auto my-4 text-white wow slideInUp">
        <h2>Subscribe to <span class="text-primary">Newsletter</span></h2>
        <p class="lead">
          Get notified about new courses, events, community & more
        </p>
      </div>
      <div class="col-md-6 my-4 wow zoomIn">
      <div class="input-group">
        <div class="input-group-prepend">
          <div class="input-group-text ti-email bg-white"></div>
        </div>
        <input type="text" placeholder="Enter your email" class="form-control py-3 pl-0 border-white" required>
        <div class="input-group-append">
          <button class="btn btn-primary" type="submit">Subscribe</button>
        </div>
      </div>
      </div>
    </div> <!-- END row-->
    </div>
  </section> --}}



<section class="paddingTop-100">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12 text-center">
        <h2 class="mb-4">
          {{ __('messages.gallery') }}
        </h2>
        <div class="width-3rem height-4 rounded bg-primary mx-auto"></div>
      </div>
    </div> <!-- END row-->

    <div class="row marginTop-60">
      <div class="owl-carousel arrow-edge arrow-black" data-space="0"  data-items="4" data-arrow="true" data-tablet-items="2" data-mobile-items="1">

        @foreach ($images as $image)
        <div class="hover:parent">
          <img class="w-100 transition-0_3 hover:zoomin" src="{{ cropped_Image($image->image) }}" alt="">
          <div class="card-img-overlay transition-0_3 flex-center bg-black-0_7 hover:show">
            <a href="{{ Image($image->image) }}" data-fancybox="gallery1" class="iconbox iconbox-md bg-white ti-zoom-in text-primary"></a>
          </div>
        </div>
        @endforeach







      </div>
    </div> <!-- END row-->

  </div> <!-- END container-->
</section>













@endsection

@section('extra-js')
@endsection
