@if(!isset($innerLoop))
<ul class="nav navbar-nav ec-nav__navbar ml-auto">
@else
<ul class="dropdown-menu">
@endif

@php

    if (Voyager::translatable($items)) {
        $items = $items->load('translations');
    }

@endphp

@foreach ($items as $item)

    @php

        $originalItem = $item;
        if (Voyager::translatable($item)) {
            $item = $item->translate($options->locale);
        }

        $listItemClass = null;
        $linkAttributes =  isset($AnasAttributes)?$AnasAttributes:NULL;
        $styles = null;
        $icon = null;
        $caret = null;

        // Background Color or Color
        if (isset($options->color) && $options->color == true) {
            $styles = 'color:'.$item->color;
        }
        if (isset($options->background) && $options->background == true) {
            $styles = 'background-color:'.$item->color;
        }

        // With no Children Attributes
        if($item->children->isEmpty() && !isset($AnasAttributes)) {
        $linkAttributes = 'class="no-class" data-toggle="no-toggle"';
        if(url($item->link()) == url()->current()){
        $listItemClass = 'nav-item';
        }else{
        $listItemClass = 'nav-item';
        }
        }
        // With Children Attributes
        if(!$originalItem->children->isEmpty() && !isset($AnasAttributes)) {
            $linkAttributes =  'class="nav-link dropdown-toggle" data-toggle="dropdown"';
            $caret = '<span class="caret"></span>';

            if(url($item->link()) == url()->current()){
                $listItemClass = 'nav-item nav-item__has-dropdown';
            }else{
                $listItemClass = 'nav-item nav-item__has-dropdown';
            }
        }elseif(!isset($AnasAttributes)) {
             $linkAttributes =  'class="nav-link"';
        }

        // Set Icon
        if(isset($options->icon) && $options->icon == true){
            $icon = '<i class="' . $item->icon_class . '"></i>';
        }

    @endphp

    <li class="{{ $listItemClass }}">
        <a href="{{ url($item->link()) }}" target="{{ $item->target }}" style="{{ $styles }}" {!! $linkAttributes or '' !!}>
            {!! $icon !!}
            <span>{{ $item->title }}</span>
            {!! $caret !!}
        </a>
        @if(!$originalItem->children->isEmpty())
        @include('main-menu', ['items' => $originalItem->children, 'options' => $options, 'innerLoop' => true,'AnasAttributes' => 'class="nav-link__list" '])
        @endif
    </li>
@endforeach

</ul>
