<!doctype html>
<?php
   $rtl = '';
   if (App::isLocale('ar') || App::isLocale('he')) {
       $rtl = '-rtl';
   }
?>
<html lang="{{ app()->getLocale() }}">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <!-- viewport scale-->
         <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>@yield('title', '')</title>
        <!-- SEO Meta-->
        <meta name="description" content="Academic City International School by EduSoft">
        <meta name="keywords" content="Academic City International School">
        <meta name="author" content="EduSoft">

        <link href="{{url('')}}/assets/img/favicon/favicon.ico" rel="SHORTCUT ICON" />

        <!--Google fonts-->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Maven+Pro:400,500,700%7CWork+Sans:400,500">
        <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css"/>



        <!-- Icon fonts -->
        <link rel="stylesheet" href="{{url('')}}/assets/fonts/fontawesome/css/all.css">
        <link rel="stylesheet" href="{{url('')}}/assets/fonts/themify-icons/css/themify-icons.css">


        <!-- stylesheet-->
        <link rel="stylesheet" href="{{url('')}}/assets/css/vendors.bundle.css">
        @php
         if (App::isLocale('ar') || App::isLocale('he'))
         {
        @endphp
        <link rel="stylesheet" href="{{asset("assets/css/bootstrap{$rtl}.css")}}">
        @php
        }
        @endphp
        <link rel="stylesheet" href="{{asset("assets/css/style-in{$rtl}.css")}}">



        @yield('extra-css')
    </head>


<body class="@yield('body-class', '')">


    @include('header')

    @yield('content')

    @include('footer')


    <script src="{{url('')}}/assets/js/vendors.bundle.js"></script>
    <script src="{{asset("assets/js/scripts{$rtl}.js")}}"></script>

    <script type="text/javascript">
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
    </script>

     @yield('extra-js')

</body>
</html>
