@extends('layout')

@section('title', '')
@section('body-class',  __('messages.faq') )
@section('extra-css')
@endsection


@section('content')


<div class="padding-y-80 bg-cover" data-dark-overlay="6" style="background:url({{url('')}}/assets/img/breadcrumb-bg.jpg) no-repeat">
  <div class="container">
    <h2 class="text-white">
        {{ __('messages.faq') }}
    </h2>
    <ol class="breadcrumb breadcrumb-double-angle text-white bg-transparent p-0">
      <li class="breadcrumb-item"><a href="/">{{ __('messages.home') }}</a></li>
      <li class="breadcrumb-item">{{ __('messages.faq') }}</li>
    </ol>
  </div>
</div>



<section class="padding-y-80">
   <div class="container">
      <div class="row">
         <div class="col-12 text-center">
            <h2>{{ __('messages.faq') }}</h2>
            <div class="width-4rem height-4 bg-primary rounded mt-4 marginBottom-40 mx-auto"></div>
         </div>

         @foreach ($faqs as $faq)
         <div class="col-md-6">
            <div class="mb-5">
               <h4 class="mb-3">
                  {{ $faq->getTranslatedAttribute('qus', $locale, $fall_back_locale) }}
               </h4>
               <p>
                 {{ $faq->getTranslatedAttribute('answer', $locale, $fall_back_locale) }}
               </p>
            </div>
         </div> <!-- END col-md-6 -->
         @endforeach

      </div> <!-- END row-->
   </div> <!-- END container-->
</section> <!-- END -->











<section class="padding-y-100 bg-light-v2">
  <div class="container">

   <div class="row">
     <div class="col-lg-6 m-auto text-center">
       <h2 class="h1">
        {{ __('messages.faq') }}
       </h2>
       <div class="width-4rem height-4 bg-primary rounded mt-4 marginBottom-40 mx-auto"></div>
     </div>

       <div class="col-12 mt-4">
          <div id="accordion-7" class="accordion-style-7 bg-white shadow-v1">


            @php
              $i=0;
            @endphp
            @foreach ($faqs as $faq)
              <div class="accordion-item border-bottom border-light">
             <a href="#acc7_{{ $i }}" class="accordion__title h6 mb-0 py-3 px-4 @php if($i>0){echo 'collapsed';} @endphp" data-toggle="collapse" aria-expanded="true">
               <span class="accordion__icon small mr-2 mt-1">
                <i class="ti-angle-down"></i>
                <i class="ti-angle-up"></i>
              </span>
              {{ $faq->getTranslatedAttribute('qus', $locale, $fall_back_locale) }}
             </a>
              <div id="acc7_{{ $i }}" class="collapse @php if($i==0){echo 'show';} @endphp" data-parent="#accordion-7">
                <div class="px-4">
                   <p>
                    {{ $faq->getTranslatedAttribute('answer', $locale, $fall_back_locale) }}
                   </p>
                </div>
              </div>
            </div> <!-- END accordion-item-->

            @php
              $i++;
            @endphp
            @endforeach





          </div> <!-- END accordion-7-->
         </div> <!-- END col-12 -->

   </div> <!-- END row-->

  </div> <!-- END container-->
</section> <!-- END section-->
















@endsection

@section('extra-js')
@endsection
