@extends('layout')

@section('title', $event->getTranslatedAttribute('title', $locale, $fall_back_locale))
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')


<div class="padding-y-80 bg-cover" data-dark-overlay="6" style="background:url({{url('')}}/assets/img/breadcrumb-bg.jpg) no-repeat">
  <div class="container">
    <h2 class="text-white">
       {{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}
    </h2>
    <ol class="breadcrumb breadcrumb-double-angle text-white bg-transparent p-0">
      <li class="breadcrumb-item"><a href="/">{{ __('messages.home') }}</a></li>
      <li class="breadcrumb-item"><a href="/">{{ __('messages.events') }}</a></li>
      <li class="breadcrumb-item">{{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</li>
    </ol>
  </div>
</div>










<section class="padding-y-60 bg-light">
  <div class="container">
    <div class="row">

      <div class="col-lg-8 mt-4">
       <div class="card shadow-v1">
         <div class="position-relative">
           <img class="card-img-top w-100" src="{{ newsImagecrop($event->image) }}" alt="">
         </div>


       </div>
      </div>

      <div class="col-lg-4 mt-4">
        <div class="card shadow-v1">
          <div class="card-body">


            <div class="border-bottom py-3">
              <div class="media">
                <i class="ti-calendar text-primary mt-2"></i>
                <div class="media-body ml-3">
                  <h6 class="my-0">{{ __('messages.date') }}</h6>
                  <span>{{ $event->date }}</span>
                </div>
              </div>
            </div>

            <div class="border-bottom py-3">
              <div class="media">
                <i class="ti-time text-primary mt-2"></i>
                <div class="media-body ml-3">
                  <h6 class="my-0">{{ __('messages.time') }}</h6>
                  <span>{{ date('G:i', strtotime($event->time)) }}</span>
                </div>
              </div>
            </div>

            <div class="border-bottom py-3">
              <div class="media">
                <i class="ti-location-pin text-primary mt-2"></i>
                <div class="media-body ml-3">
                  <h6 class="my-0">{{ __('messages.address') }}</h6>
                  <span>{{ $event->getTranslatedAttribute('address', $locale, $fall_back_locale) }}</span>
                </div>
              </div>
            </div>

            <div class="border-bottom py-3">
              <div class="media">
                <i class="ti-user text-primary mt-2"></i>
                <div class="media-body ml-3">
                  <h6 class="my-0">{{ __('messages.slots') }}</h6>
                  <span>{{ $event->slots }}</span>
                </div>
              </div>
            </div>


          </div>
        </div>
      </div>







        <div class="col-lg-12 mt-4">
       <div class="card shadow-v1">






         <div class="card-body padding-40">
           <h2 class="card-title">
             {{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}
           </h2>


            <div class="tab-pane fade active show" id="Tabs_1-1" role="tabpanel">

                {!! $event->getTranslatedAttribute('body', $locale, $fall_back_locale) !!}


               {{-- <ul class="list-inline d-inline-block py-3 px-4 shadow-v3 bg-white rounded-pill">
                  <li class="list-inline-item">Share <span class="d-none d-md-inline-block">this course:</span></li>
                  <li class="list-inline-item mx-0">
                    <a href="#" class="btn btn-opacity-primary iconbox iconbox-sm">
                      <i class="ti-facebook"></i>
                    </a>
                  </li>
                  <li class="list-inline-item mx-0">
                    <a href="#" class="btn btn-opacity-primary iconbox iconbox-sm">
                      <i class="ti-twitter"></i>
                    </a>
                  </li>
                  <li class="list-inline-item mx-0">
                    <a href="#" class="btn btn-opacity-primary iconbox iconbox-sm">
                      <i class="ti-linkedin"></i>
                    </a>
                  </li>
                  <li class="list-inline-item mx-0">
                    <a href="#" class="btn btn-opacity-primary iconbox iconbox-sm">
                      <i class="ti-google"></i>
                    </a>
                  </li>
                </ul> --}}



            </div>








         </div>














          </div>
      </div>







    </div> <!-- END row-->
  </div> <!-- END container-->
</section>











@endsection

@section('extra-js')
@endsection
