@extends('layout')

@section('title', __('messages.contact'))
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')












<div class="py-5 bg-cover" data-dark-overlay="6" style="background:url(../assets/img/1920/658_2.jpg) no-repeat">
  <div class="container">
    <h2 class="text-white">
      {{ __('messages.contact') }}
    </h2>
    <ol class="breadcrumb breadcrumb-double-angle text-white bg-transparent p-0">  
      <li class="breadcrumb-item"><a href="#">{{ __('messages.home') }}</a></li>
      <li class="breadcrumb-item">{{ __('messages.contact') }}</li>
    </ol>
  </div>
</div>
    
   
   
   <div class="py-5 shadow-v2 position-relative">
     <div class="container">
       <div class="row">
        
         <div class="col-lg-4 col-md-6 mt-4">
           <div class="media">
             <span class="iconbox iconbox-md bg-primary text-white"><i class="ti-mobile"></i></span>
             <div class="media-body ml-3" style="margin: auto 5px;">
              <h5 class="mb-0">{{ setting('site.mobile') }}</h5> 
             </div>
           </div>
         </div>
        
         <div class="col-lg-4 col-md-6 mt-4">
           <div class="media">
             <span class="iconbox iconbox-md bg-primary text-white"><i class="ti-email"></i></span>
             <div class="media-body ml-3" style="margin: auto 5px;">
              <a href="mailto:support@acs.edu.sa" class="h5">{{ setting('site.email') }}</a>
             </div>
           </div>
         </div>
        
         <div class="col-lg-4 col-md-6 mt-4">
           <div class="media">
             <span class="iconbox iconbox-md bg-primary text-white"><i class="ti-location-pin"></i></span>
             <div class="media-body ml-3" style="margin: auto 5px;">
              <h5 class="mb-0">@php if( App::getLocale() == 'ar' || App::getLocale() == 'he'){ echo setting('site.address_ar'); }else { echo setting('site.address'); } @endphp</h5> 
             </div>
           </div>
         </div>
         
       </div>
     </div>
   </div>
   
   
   
   
  <section class="padding-y-100 bg-light-v2">
  <div class="container">
    <div class="row">
     <div class="col-12 text-center mb-5">
        <h2>
          {{ __('messages.contact_title') }}
        </h2>
        <div class="width-4rem height-4 bg-primary my-2 mx-auto rounded"></div>
      </div>
      <div class="col-12 text-center">
      	<div class="alert alert-danger print-error-msg" style="display:none">
                                <ul></ul>
                                </div>

                                <div class="alert alert-success print-msg" style="display:none">
                                <p>{{ __('messages.contact_thanks') }}</p>
                                </div>

        <form  id="contactform" class="card p-4 p-md-5 shadow-v1">
          <p class="lead mt-2">
            {{ __('messages.contact_text') }}
          </p>


          <div class="row mt-5 mx-0">
            <div class="col-md-4 mb-4">
            	<input type="text" class="form-control"  size="30" value="" name="name" id="name" placeholder="{{ __('messages.contact_name_input') }}">
            </div>
            <div class="col-md-4 mb-4">
            	<input type="email" class="form-control"  size="30" value="" name="email" id="email" placeholder="{{ __('messages.contact_email_input') }}">
            </div>
            <div class="col-md-4 mb-4">
            	<input type="text" class="form-control"  size="30" value="" name="phone" id="phone" placeholder="{{ __('messages.contact_phone_input') }}">
            </div>
            <div class="col-12">
            	<textarea  class="form-control" rows="7" name="message" id="message" placeholder="{{ __('messages.contact_message_input') }}"></textarea>
              <button type="submit" id="submit" class="btn btn-primary mt-4 btn-submit">{{ __('messages.contact_submit') }}</button>
            </div>
          </div>


        </form>  
      </div>
      
    </div> <!-- END row-->
  </div> <!-- END container-->
</section>
  
  
  
    
    
 <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3621.9568018925524!2d46.741437484514414!3d24.796932684083874!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2efdd03dc339b5%3A0x50c87c66431b0644!2sAcademic+City+Schools!5e0!3m2!1sar!2s!4v1543714289405" width="100%" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>









@endsection

@section('extra-js')
<script type="text/javascript">
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(".btn-submit").click(function(e){
        e.preventDefault();

        var name = $("input[name=name]").val();
        var email = $("input[name=email]").val();
        var phone = $("input[name=phone]").val();
        var message = $("textarea[name=message]").val();

        $.ajax({
           type:'POST',
           url:'/contact',
           data:{name:name, email:email, phone:phone, message:message},
           success: function(data) {
	                if($.isEmptyObject(data.error)){
	                	printMsg(data.success);
	                }else{
	                	printErrorMsg(data.error);
	                }
	            }
        });
        function printErrorMsg (msg) {
            $(".print-msg").css('display','none');
			$(".print-error-msg").find("ul").html('');
			$(".print-error-msg").css('display','block');
			$.each( msg, function( key, value ) {
				$(".print-error-msg").find("ul").append('<li>'+value+'</li>');
			});
        }
        function printMsg (msg) {
            document.getElementById("submit").disabled = true;
            $(".print-error-msg").css('display','none');
            $(".print-msg").css('display','block');
            $("#contactform")[0].reset();
        }




	});
</script>
@endsection
