@extends('layout')

@section('content')


<section class="padding-y-100 bg-light">
  <div class="container">
    <div class="row">
      <div class="col-lg-6 mx-auto">
        <div class="card shadow-v2"> 
         <div class="card-header border-bottom">
          <h4 class="mt-4">
            {{ __('messages.register') }}
          </h4>
         </div>         
          <div class="card-body">
            <form method="POST" action="{{ route('register') }}" aria-label="{{ __('messages.register') }}" class="px-lg-4">
            @csrf

              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-user"></span>
                </div>
                <input id="name" type="text" class="form-control border-left-0 pl-0 {{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') }}" placeholder="{{ __('messages.name') }}" required autofocus >
                @if ($errors->has('name'))
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $errors->first('name') }}</strong>
                        </span>
                    @endif
                </div>

             



              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-email"></span>
                </div>
                <input id="email" type="email" class="form-control border-left-0 pl-0 {{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}"  placeholder="{{ __('messages.mail') }}" required >
                @if ($errors->has('email'))
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
              </div>



              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-lock"></span>
                </div>
                <input id="password" type="password" class="form-control border-left-0 pl-0 {{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" placeholder="{{ __('messages.password') }}" required="">
                @if ($errors->has('password'))
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                @endif
              </div>

              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-lock"></span>
                </div>
                <input id="password-confirm" type="password" class="form-control border-left-0 pl-0 {{ $errors->has('password') ? ' is-invalid' : '' }}" name="password_confirmation" placeholder="{{ __('messages.confirm_password') }}" required="">
               
              </div>



              <!-- <div class="my-4">
                <label class="ec-checkbox check-sm my-2 clearfix">
                  <input type="checkbox" name="checkbox">
                  <span class="ec-checkbox__control mt-1"></span>
                  <span class="ec-checkbox__lebel">
                    By signing up, you agree to our 
                    <a href="#" class="text-primary">Terms of Use</a>
                     and
                    <a href="#" class="text-primary">Privacy Policy.</a>
                  </span>
                </label>
              </div> -->


              <button class="btn btn-block btn-primary">{{ __('messages.register') }}</button>
              <p class="my-5 text-center">
                {{ __('messages.login_text') }} <a href="{{ route('login') }}" class="text-primary">{{ __('messages.login') }}</a>
              </p>



            </form>
          </div>
        </div>
      </div> 
    </div> <!-- END row-->
  </div> <!-- END container-->
</section>






@endsection
