@extends('layout')

@section('content')







<section class="padding-y-100 bg-light">
  <div class="container">
    <div class="row">
      <div class="col-lg-6 mx-auto">
        <div class="card shadow-v2"> 
         <div class="card-header px-lg-5 border-bottom">
          <h4 class="mt-4">
            {{ __('messages.reset_password_get') }}
          </h4>
         </div>         
          <div class="card-body">
            @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
            <form method="POST" action="{{ route('password.email') }}" aria-label="{{ __('Reset Password') }}" class="px-lg-5">
            @csrf
             <p class="marginBottom-40">
               {{ __('messages.reset_password_text') }}
             </p>
              <div class="input-group input-group--focus marginBottom-40">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-email"></span>
                </div>
                <input id="email" type="email" class="form-control border-left-0 pl-0  {{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" placeholder="{{ __('messages.mail') }}" required="">
                @if ($errors->has('email'))
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
              </div>
              <button class="btn btn-block btn-primary mb-5" type="submit">{{ __('messages.reset_password') }}</button>
            </form>
          </div>
        </div>
      </div> 
    </div> <!-- END row-->
  </div> <!-- END container-->
</section>








@endsection
