@extends('layout')

@section('title', __('messages.news'))
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')



<!--Banner Wrap Start-->
        <section class="sub_banner_wrap" style="background-image: url({{ image(setting('site.pages_header_image')) }});">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="sub_banner_hdg">
                            <h3>{{ __('messages.news') }}</h3>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="ct_breadcrumb">
                            <ul>
                                <li><a href="/">{{ __('messages.home') }}</a></li>
                                <li><a href="{{ route('news') }}">{{ __('messages.news') }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Banner Wrap End-->

    <!--Latest News Wrap Start-->
    <section class="ct_blog_simple_bg">
        <div class="container">
            <!--Heading Style 1 Wrap Start-->
            <div class="ct_heading_1_wrap">
                <h3>{{ __('messages.news') }}</h3>
                <span><img src="{{url('')}}/assets/images/hdg-01.png" alt=""></span>
            </div>
            <!--Heading Style 1 Wrap End-->

            <!--Latest News Wrap Start-->
            <div class="row">
              @foreach ($news as $news_single)
                <div class="col-md-4">
                    <a href="{{ route('news.show', ['slug' => $news_single->slug]) }}">
                  <img  src="{{ cropped_Image($news_single->image) }}" alt="" style="min-height: 254px; border-radius:5px; padding:5px auto;margin-bottom: 5px;">
                    <div class="ct_news_wrap">
                        <span>{{ $news_single->created_at->format('d') }}-{{ $news_single->created_at->format('M') }}-{{ $news_single->created_at->format('Y') }}</span>
                        <h5><a href="{{ route('news.show', ['slug' => $news_single->slug]) }}">{{ $news_single->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</a></h5>
                        <p>{{ $news_single->getTranslatedAttribute('excerpt', $locale, $fall_back_locale) }}</p>
                    </div>
                    </a>
                </div>
                @endforeach
            </div>
            <!--Latest News Wrap End-->
             <div class="row">
                        <div class="col-md-12" style="margin-top:80px;">
                             <!--Pagination Wrap Start-->
                            <div class=" text-center center-block center">
                                {{ $news->links() }}
                            </div>
                            <!--Pagination Wrap End-->
                        </div>
                    </div>
                    <!-- END row-->
        </div>
    </section>
    <!--Latest News Wrap End-->



@endsection

@section('extra-js')
@endsection
