@extends('layout')

@section('title', setting('site.title') )
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')





<!--Banner Wrap Start-->
<div class="banner_outer_wrap">
    <ul class="main_slider">

    @foreach ($sliders as $slider)
        <li>
          <div class="over-lay"></div>
            <img src="{{  cropped_Image($slider->image) }}" alt="">
            <div class="ct_banner_caption">
                <h4 class="fadeInDown">
                    <a href="{{ route('slider_single', $slider->id) }}" style="text-decoration: none;" target="_blank">
                        {{ $slider->getTranslatedAttribute('sub_title', $locale, $fall_back_locale) }}
                    </a>
                </h4>
                <h2 class="fadeInDown">
                    <a href="{{ route('slider_single', $slider->id) }}" style="text-decoration: none;" target="_blank">
                        {{ $slider->getTranslatedAttribute('title', $locale, $fall_back_locale) }}
                    </a>
                </h2>
            </div>
        </li>
    @endforeach


    </ul>
</div>
<!--Banner Wrap End-->



<!--Content Wrap Start-->
<div class="ct_content_wrap">

  <!--Get Started Wrap Start-->
    <section>
        <div class="container">
            <div class="get_started_outer_wrap">
                <div class="row">
                    <div class="col-md-6">
                        <div class="get_started_content_wrap ct_blog_detail_des_list">
                            <h3> <?php if( App::getLocale() == 'ar' || App::getLocale() == 'he'){ echo setting('about.title_ar'); }else { echo setting('about.title'); } ?></h3>
                            <p> <?php if( App::getLocale() == 'ar' || App::getLocale() == 'he'){ echo setting('about.body_ar'); }else { echo setting('about.body'); } ?></p>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="get_started_video">
                            <img src="{{ Image(setting('about.image')) }}" alt="">
                            <div class="get_video_icon">
                                <a data-rel="prettyPhoto" href="{{ setting('about.video') }}"><i class="fa fa-play"></i></a>
                                <span><?php if( App::getLocale() == 'ar' || App::getLocale() == 'he'){ echo setting('about.video_text_ar'); }else { echo setting('about.video_text_ar'); } ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!--Get Started Wrap End-->

    <!--Courses By Subject Wrap Start-->
    <section class="ct_courses_subject_bg">
        <div class="container">
            <!--Heading Style 1 Wrap Start-->
            <div class="ct_heading_1_wrap ct_white_hdg">
                <h3>{{ __('messages.services') }}</h3>
                <span><img src="{{url('')}}/assets/images/hdg-01.png" alt=""></span>
            </div>
            <!--Heading Style 1 Wrap End-->

            <!--Courses Subject List Wrap Start-->
            <div class="courses_subject_carousel owl-carousel">
              <?php
              $x=1;
              ?>
              @foreach ($services as $service)
              <?php
              if ($x == 7) {
                 $x=1;
              }
              ?>
              <div class="item">
                    <div class="course_subject_wrap ct_bg_{{ $x }}">
                        <i class="fa {{ $service->icon }}"></i>
                        <div class="course_subject_des">
                            <p>{{ $service->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</p>
                        </div>
                    </div>
                </div>
                <?php
                $x++;
                ?>
                @endforeach

            </div>
            <!--Courses Subject List Wrap End-->
        </div>
    </section>
    <!--Courses By Subject Wrap End-->

  <!--Our Events Wrap Start-->
    <section class="event_bg">
        <div class="container">
            <!--Heading Style 1 Wrap Start-->
            <div class="ct_heading_1_wrap">
                <h3>{{ __('messages.events') }}</h3>
                <span><img src="{{url('')}}/assets/images/hdg-01.png" alt=""></span>
            </div>
            <!--Heading Style 1 Wrap End-->

            <!--Event List Wrap Start-->
            <div class="row">
                <div class="col-md-12">
                    <div class="row">
                      @foreach ($events as $event)
                        <div class="col-md-4">
                          <a href="{{ route('events.show', ['slug' => $event->slug]) }}">
                           <div class="ct_main_event_wrap" style="background-image:url({{ cropped_Image($event->image) }})">
                                <h4>{{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</h4>
                                <h5><span>{{ $event->date }}</span></h5>
                                <ul class="event_location_list">
                                    <li><i class="fa fa-map-marker"></i>{{ $event->getTranslatedAttribute('address', $locale, $fall_back_locale) }}</li>
                                    <li><i class="fa fa-clock-o"></i>{{ date('G:i', strtotime($event->time)) }}</li>
                                </ul>
                            </div>
                            </a>
                        </div>
                        @endforeach

                    </div>
                </div>

            </div>
            <!--Event List Wrap End-->

        </div>
    </section>
    <!--Our Events Wrap End-->

    <!--Figures & Facts Wrap Start-->
    <section class="ct_facts_bg">
        <ul>
          @foreach ($counters as $counter)
            <li>
                <i class="fa {{ $counter->icon }}"></i>
                <h2 class="counter">{{ $counter->number }}</h2>
                <span>{{ $counter->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</span>
            </li>
             @endforeach

        </ul>
    </section>
    <!--Figures & Facts Wrap End-->

    <!--Latest News Wrap Start-->
    <section class="ct_blog_simple_bg">
        <div class="container">
            <!--Heading Style 1 Wrap Start-->
            <div class="ct_heading_1_wrap">
                <h3>{{ __('messages.news') }}</h3>
                <span><img src="{{url('')}}/assets/images/hdg-01.png" alt=""></span>
            </div>
            <!--Heading Style 1 Wrap End-->

            <!--Latest News Wrap Start-->
            <div class="row">
              @foreach ($news as $news_single)
                <div class="col-md-4">
                  <img  src="{{ cropped_Image($news_single->image) }}" alt="" style="min-height:254px;border-radius:5px; padding:5px auto;margin-bottom: 5px;">
                    <div class="ct_news_wrap">
                        <span>{{ $news_single->created_at->format('d') }}-{{ $news_single->created_at->format('M') }}-{{ $news_single->created_at->format('Y') }}</span>
                        <h5><a href="{{ route('news.show', ['slug' => $news_single->slug]) }}">{{ $news_single->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</a></h5>
                        <p>{{ $news_single->getTranslatedAttribute('excerpt', $locale, $fall_back_locale) }}</p>
                    </div>
                </div>
                @endforeach


            </div>
            <!--Latest News Wrap End-->
        </div>
    </section>
    <!--Latest News Wrap End-->




    <!--Learn More Wrap Start-->
    <div class="ct_learn_more_bg">
        <div class="container">
            <div class="ct_learn_more">
                <h4>  <span> </span></h4>
            </div>
        </div>
    </div>
    <!--Learn More Wrap End-->


 <!--Gallery Wrap Start-->
    <section class="ct_blog_simple_bg">
        <div class="container">
            <!--Heading Style 1 Wrap Start-->
            <div class="ct_heading_1_wrap">
                <h3>{{ __('messages.gallery') }}</h3>
                <span><img src="{{url('')}}/assets/images/hdg-01.png" alt=""></span>
            </div>
            <!--Heading Style 1 Wrap End-->

            <!--Gallery Wrap Start-->
            <div class="row">


                @foreach ($images as $image)
                <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                      <a href="{{ Image($image->image) }}" class="fancybox" rel="ligthbox">
                          <img  src="{{ cropped_Image($image->image) }}" class="zoom img-fluid "  alt="">
                      </a>
                  </div>
                 @endforeach



            </div>
            <!--Gallery Wrap End-->
        </div>
    </section>
    <!--Gallery Wrap End-->








</div>
<!--Content Wrap End-->



@endsection

@section('extra-js')
<script>
 $(document).ready(function(){
  $(".fancybox").fancybox({
        openEffect: "none",
        closeEffect: "none"
    });

    $(".zoom").hover(function(){

		$(this).addClass('transition');
	}, function(){

		$(this).removeClass('transition');
	});
});

</script>


@endsection
