<!doctype html>
<?php
   $rtl = '';
   if (App::isLocale('ar') || App::isLocale('he')) {
       $rtl = '-rtl';
   }
?>
<html lang="{{ app()->getLocale() }}">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <!-- viewport scale-->
         <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>@yield('title', '')</title>
        <!-- SEO Meta-->
        <meta name="description" content="">
        <meta name="keywords" content="">
        <meta name="author" content="sirreya">

        <link href="{{url('')}}/assets/img/favicon/favicon.ico" rel="SHORTCUT ICON" />


         <!-- Bootstrap core CSS -->
    <link href="{{url('')}}/assets/css/bootstrap.min.css" rel="stylesheet">
     @php
         if (App::isLocale('ar') || App::isLocale('he'))
         {
        @endphp
        <link rel="stylesheet" href="{{asset("assets/css/bootstrap{$rtl}.css")}}">
        @php
        }
        @endphp
    <!-- Bx-Slider StyleSheet CSS -->
    <link href="{{url('')}}/assets/css/jquery.bxslider.css" rel="stylesheet">
    <!-- Font Awesome StyleSheet CSS -->
    <link href="{{url('')}}/assets/css/font-awesome.css" rel="stylesheet">
    <link href="{{url('')}}/assets/css/svg-style.css" rel="stylesheet">
    <!-- Pretty Photo CSS -->
    <link href="{{url('')}}/assets/css/prettyPhoto.css" rel="stylesheet">

    <!-- DL Menu CSS -->
    <link href="{{url('')}}/assets/js/dl-menu/component.css" rel="stylesheet">
    <!-- Typography CSS -->
    <link href="{{url('')}}/assets/css/typography.css" rel="stylesheet">
    <!-- Animation CSS -->
    <link href="{{url('')}}/assets/css/animate.css" rel="stylesheet">
    <!-- Owl Carousel CSS -->
    <link href="{{url('')}}/assets/css/owl.carousel.css" rel="stylesheet">
    <!-- Color CSS -->
    <link href="{{url('')}}/assets/css/color.css" rel="stylesheet">
    <!-- Widget CSS -->
    <link href="{{asset("assets/css/widget{$rtl}.css")}}" rel="stylesheet">
    <!-- Shortcodes CSS -->
    <link href="{{asset("assets/css/shortcodes{$rtl}.css")}}" rel="stylesheet">
    <!-- Custom Main StyleSheet CSS -->
    <link href="{{asset("assets/css/style{$rtl}.css")}}" rel="stylesheet">
    <!-- Responsive CSS -->
    <link href="{{asset("assets/css/responsive{$rtl}.css")}}" rel="stylesheet">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.css" media="screen">



        @yield('extra-css')
    </head>


<body class="@yield('body-class', '')">
    <!--Wrapper Start-->
    <div class="ct_wrapper">

    @include('header')

    @yield('content')

    @include('footer')

    </div>
    <!--Wrapper End-->


     <!--Bootstrap core JavaScript-->
    <script src="{{url('')}}/assets/js/jquery.js"></script>
    <script src="{{url('')}}/assets/js/bootstrap.min.js"></script>
    <!--Bx-Slider JavaScript-->
    <script src="{{url('')}}/assets/js/jquery.bxslider.min.js"></script>
    <!--Dl Menu Script-->
    <script src="{{url('')}}/assets/js/dl-menu/modernizr.custom.js"></script>
    <script src="{{url('')}}/assets/js/dl-menu/jquery.dlmenu.js"></script>
    <!--Owl Carousel JavaScript-->
    <script src="{{url('')}}/assets/js/owl.carousel.js"></script>
    <!--Time Counter Javascript-->
    <script src="{{url('')}}/assets/js/jquery.downCount.js"></script>
    <!--Pretty Photo Javascript-->
    <script src="{{url('')}}/assets/js/jquery.prettyPhoto.js"></script>
    <!--Way Points Javascript-->
    <script src="{{url('')}}/assets/js/waypoints-min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.js"></script>
    <!--Custom JavaScript-->
    <script src="{{url('')}}/assets/js/custom.js"></script>

    {{-- <script src="{{asset("assets/js/scripts{$rtl}.js")}}"></script> --}}

    <script type="text/javascript">
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
    </script>

     @yield('extra-js')

</body>
</html>
