@extends('layout') 
@section('title', __('messages.gallery')) 
@section('body-class', '' ) 
@section('extra-css')
<link href="{{url('')}}/assets/css/gallery.css" rel="stylesheet">
@endsection 

@section('content')

<!--Banner Wrap Start-->
<section class="sub_banner_wrap" style="background-image: url({{ image(setting('site.pages_header_image')) }});">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="sub_banner_hdg">
                    <h3>{{ __('messages.gallery') }}</h3>
                </div>
            </div>
            <div class="col-md-6">
                <div class="ct_breadcrumb">
                    <ul>
                        <li><a href="/">{{ __('messages.home') }}</a></li>
                        <li><a href="#">{{ __('messages.gallery') }}</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!--Banner Wrap End-->

<!--Gallery Wrap Start-->
<section class="ct_blog_simple_bg">
    <div class="container">
        <!--Gallery Wrap Start-->
        <div class="row">
            @foreach ($images as $image)
            <div class="col-lg-3 col-sm-4 col-xs-6">
                    {{-- <div class="content"> --}}
                        {{-- <div class="content-overlay"></div> --}}
                        <img class="img-hov thumbnail img-responsive img-fluid zoom" src="{{ cropped_Image($image->image) }}" data-toggle="modal" data-target="#{{ $image->id }}">
                        {{-- <div class="content-details fadeIn-top">
                            <h3>{{ $image->getTranslatedAttribute('title',$locale,$fall_back_locale)}}</h3>
                            <p>{{ $image->getTranslatedAttribute('description',$locale,$fall_back_locale)}}</p>
                        </div> --}}
                    {{-- </div> --}}
            </div>
            <div class="modal fade galleryModal" id="{{ $image->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle">{{ $image->getTranslatedAttribute('title',$locale,$fall_back_locale)}}</h5>
                            <span>{{ $image->getTranslatedAttribute('description',$locale,$fall_back_locale)}}</span>
                        </div>
                        <div class="modal-body">
                            <div class="product-section">
                                <div class="product-pic-zoom text-center">
                                    <img class="product-big-img" src="{{ cropped_Image($image->image) }}" alt="" style="width: 100%;">
                                </div>
                                <div class="product-thumbs" tabindex="1" style="overflow: hidden; outline: none;">
                                    <div class="product-thumbs-track mt-5">
                                        <img class="pt" src="{{ cropped_Image($image->image) }}" data-imgbigurl="{{ cropped_Image($image->image) }}" alt="" style="height:75px">
                                        @foreach (json_decode($image->images) as $item)
                                        <div class="pt" data-imgbigurl="{{ cropped_Image($item) }}">
                                            <img src="{{ cropped_Image($item) }}" alt="">
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-----------End Nodal -------------------->
            @endforeach
        </div>

        <div class="row">
            <div class="col-md-12" style="margin-top:80px;">
                <!--Pagination Wrap Start-->
                <div class=" text-center center-block center">
                    {{ $images->links() }}
                </div>
                <!--Pagination Wrap End-->
            </div>
        </div>
        <!-- END row-->
        <!--Gallery Wrap End-->
    </div>
</section>
<!--Gallery Wrap End-->

@endsection 
@section('extra-js')
<script>
    (function($) {
        $('.img-hov').on('click' , function(){
            img = $(this).attr('src');
            $('.product-big-img').attr('src' , img)
        })
        $('.pt').on('click', function() {
            $('.pt').removeClass('active');
            $(this).addClass('active').fadeIn(500);
            var imgurl = $(this).data('imgbigurl');
            var bigImg = $('.product-big-img').attr('src');
            if (imgurl != bigImg) {
                $('.product-big-img').attr({
                    src: imgurl
                });
                $('.zoomImg').attr({
                    src: imgurl
                });
            }
        });

        $(".zoom").hover(function() {
            $(this).addClass('transition');
        }, function() {
            $(this).removeClass('transition');
        });
    })(jQuery);
</script>
@endsection