@extends('layout')

@section('title', __('messages.faq'))
@section('body-class', '')
@section('extra-css')
<style>

.mb-5{
  margin-bottom: 5px;
}
.mb-3{
  margin-bottom: 3px;
}
</style>
@endsection


@section('content')




<!--Banner Wrap Start-->
        <section class="sub_banner_wrap" style="background-image: url({{ image(setting('site.pages_header_image')) }});">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="sub_banner_hdg">
                            <h3>{{ __('messages.faq') }}</h3>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="ct_breadcrumb">
                            <ul>
                                <li><a href="/">{{ __('messages.home') }}</a></li>
                                <li><a href="{{ route('faq') }}">{{ __('messages.faq') }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Banner Wrap End-->








<!--Content Wrap Start-->
        <div class="ct_content_wrap"  style="margin-bottom:6rem !important;">
            <section class="ct_blog_outer_wrap">
                <div class="container">
                    <div class="row">
                        <!--Blog Detail Wrap Start-->
                        <div class="col-md-12">
                            <div class="ct_blog_detail_outer_wrap">
                                <div class="ct_blog_detail_des">
                                     @foreach ($faqs as $faq)
                                      <div class="col-md-6">
                                          <div class="mb-5">
                                            <h4 class="mb-3">
                                                {{ $faq->getTranslatedAttribute('qus', $locale, $fall_back_locale) }}
                                            </h4>
                                            <p>
                                              {{ $faq->getTranslatedAttribute('answer', $locale, $fall_back_locale) }}
                                            </p>
                                          </div>
                                      </div> <!-- END col-md-6 -->
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <!--Blog Detail Wrap End-->
                    </div>
                </div>
            </section>
        </div>
		<!--Content Wrap End-->





@endsection

@section('extra-js')
@endsection
