@extends('layout')

@section('title', __('messages.events'))
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')


<!--Banner Wrap Start-->
        <section class="sub_banner_wrap" style="background-image: url({{ image(setting('site.pages_header_image')) }});">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="sub_banner_hdg">
                            <h3>{{ __('messages.events') }}</h3>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="ct_breadcrumb">
                            <ul>
                                <li><a href="/">{{ __('messages.home') }}</a></li>
                                <li><a href="{{ route('events') }}">{{ __('messages.events') }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Banner Wrap End-->








 <!--Our Events Wrap Start-->
    <section class="event_bg">
        <div class="container">

            <!--Event List Wrap Start-->
            <div class="row">
                <div class="col-md-12">
                    <div class="row">
                      @foreach ($events as $event)
                        <div class="col-md-4">
                          <a href="{{ route('events.show', ['slug' => $event->slug]) }}">
                           <div class="ct_main_event_wrap" style="background-image:url({{ cropped_Image($event->image) }})">
                                <h4>{{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</h4>
                                <h5><span>{{ $event->date }}</span></h5>
                                <ul class="event_location_list">
                                    <li><i class="fa fa-map-marker"></i>{{ $event->getTranslatedAttribute('address', $locale, $fall_back_locale) }}</li>
                                    <li><i class="fa fa-clock-o"></i>{{ date('G:i', strtotime($event->time)) }}</li>
                                </ul>
                            </div>
                            </a>
                        </div>
                        @endforeach

                    </div>
                     <div class="row">
                        <div class="col-md-12" style="margin-top:80px;">
                             <!--Pagination Wrap Start-->
                            <div class=" text-center center-block center">
                                {{ $events->links() }}
                            </div>
                            <!--Pagination Wrap End-->
                        </div>
                    </div>
                    <!-- END row-->
                </div>

            </div>
            <!--Event List Wrap End-->

        </div>
    </section>
    <!--Our Events Wrap End-->

























@endsection

@section('extra-js')
@endsection
