@extends('layout')

@section('title', $event->getTranslatedAttribute('title', $locale, $fall_back_locale))
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')




<!--Banner Wrap Start-->
        <section class="sub_banner_wrap" style="background-image: url({{ image(setting('site.pages_header_image')) }});">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="sub_banner_hdg">
                            <h3>{{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</h3>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="ct_breadcrumb">
                            <ul>
                                <li><a href="/">{{ __('messages.home') }}</a></li>
                                <li><a href="{{ route('events') }}">{{ __('messages.events') }}</a></li>
                                <li><a href="#">{{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Banner Wrap End-->













<div class="ct_content_wrap">
            <section class="ct_blog_outer_wrap">
                <div class="container">
                    <div class="row">
                        <!--Blog Detail Wrap Start-->
                        <div class="col-md-12">
                            <div class="ct_blog_detail_outer_wrap">


                              <div class="ct_blog_detail_top">
                                    <h4>{{ $event->getTranslatedAttribute('title', $locale, $fall_back_locale) }}</h4>
                                    <ul>
                                        <li>
                                            <p>
                                                <span>{{ __('messages.date') }}</span>
                                                <span>{{ $event->date }}</span>
                                            </p>
                                        </li>
                                        <li>
                                            <p>
                                                <span>{{ __('messages.time') }}</span>
                                                <span>{{ date('G:i', strtotime($event->time)) }}</span>
                                            </p>
                                        </li>
                                        <li>
                                            <p>
                                                <span>{{ __('messages.address') }}</span>
                                                <span>{{ $event->getTranslatedAttribute('address', $locale, $fall_back_locale) }}</span>
                                            </p>
                                        </li>
                                        <li>
                                            <p>
                                                <span>{{ __('messages.slots') }}</span>
                                                <span>{{ $event->slots }}</span>
                                            </p>
                                        </li>
                                    </ul>
                                </div>

                              <div class="ct_blog_detail_des">
                                <div class="col-md-4">
                                   <figure>
                                        <img src="{{ cropped_image($event->image) }}" alt="">
                                    </figure>
                                </div>
                                <div class="col-md-8">
                                  <p>{!! $event->getTranslatedAttribute('body', $locale, $fall_back_locale) !!}</p>
                                </div>
                                </div>





                            </div>
                        </div>
                        <!--Blog Detail Wrap End-->
                    </div>
                </div>
            </section>
        </div>
		<!--Content Wrap End-->

















@endsection

@section('extra-js')
@endsection
