@extends('layout')

@section('title', __('messages.contact'))
@section('body-class', '')
@section('extra-css')
@endsection


@section('content')


<!--Banner Wrap Start-->
        <section class="sub_banner_wrap" style="background-image: url({{ image(setting('site.pages_header_image')) }});">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="sub_banner_hdg">
                            <h3>{{ __('messages.contact') }}</h3>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="ct_breadcrumb">
                            <ul>
                                <li><a href="/">{{ __('messages.home') }}</a></li>
                                <li><a href="{{ route('contact') }}">{{ __('messages.contact') }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--Banner Wrap End-->










        <!--Content Wrap Start-->
        <div class="ct_content_wrap">


            <!--Get in Touch With Us Wrap Start-->
            <section>
                <div class="container">
                    <div class="get_touch_wrap">
                        <h4>{{ __('messages.contact_title') }}</h4>
                        <p>{{ __('messages.contact_text') }}</p>
                    </div>
                    <div class="row">
                        <div class="col-md-7">
                            <div class="ct_contact_form">

                                <div class="alert alert-danger print-error-msg" style="display:none">
                                <ul></ul>
                                </div>

                                <div class="alert alert-success print-msg" style="display:none">
                                <p>{{ __('messages.contact_thanks') }}</p>
                                </div>

                                <form id="contactform">
                                    <div class="form_field">
                                        <label class="fa fa-user"></label>
                                        <input type="text" class="conatct_plchldr" value="" name="name" id="name" placeholder="{{ __('messages.contact_name_input') }}">
                                    </div>
                                    <div class="form_field">
                                        <label class="fa fa-envelope-o"></label>
                                        <input type="email" class="conatct_plchldr"  value="" name="email" id="email" placeholder="{{ __('messages.contact_email_input') }}">
                                    </div>
                                    <div class="form_field">
                                        <label class="fa fa-phone"></label>
                                        <input type="text" class="conatct_plchldr"  value="" name="phone" id="phone" placeholder="{{ __('messages.contact_phone_input') }}">
                                    </div>
                                    <div class="form_field">
                                        <label class="fa fa-edit"></label>
                                        <textarea  class="conatct_plchldr" rows="3" name="message" id="message" placeholder="{{ __('messages.contact_message_input') }}"></textarea>
                                    </div>
                                    <div class="form_field">
                                        <button type="submit" id="submit" class="btn-submit">{{ __('messages.contact_submit') }}<i class="fa fa-arrow-right"></i></button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="bottom_border">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="ct_contact_address">
                                            <h5><i class="fa fa-map-o"></i>{{ __('messages.address') }}</h5>
                                            <p>@php if( App::getLocale() == 'ar' || App::getLocale() == 'he'){ echo setting('site.address_ar'); }else { echo setting('site.address'); } @endphp</p>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="ct_contact_address">
                                            <h5><i class="fa fa-envelope-o"></i>{{ __('messages.email') }}</h5>
                                            <ul class="fax_info">
                                                <li>{{ setting('site.email') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="ct_contact_address">
                                            <h5><i class="fa fa-phone"></i>{{ __('messages.phone') }}</h5>
                                            <ul class="fax_info">
                                                <li>{{ setting('site.mobile') }}</li>
                                            </ul>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </section>
            <!--Get in Touch With Us Wrap End-->

            <!--Map Wrap Start-->
            <div class="map-canvas gt_contact_us_map"><iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3787.9724293030704!2d42.68730831539583!3d18.302868987536158!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x15fb574811422027%3A0x586469f2378f5c1c!2z2YXYr9ix2LPYqSDYtdiv2Ykg2KfZhNil2KjYr9in2Lkg2KfZhNij2YfZhNmK2Kk!5e0!3m2!1sen!2s!4v1544064766657" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe></div>
            <!--Map Wrap End-->


        </div>
        <!--Content Wrap End-->




@endsection

@section('extra-js')
<script type="text/javascript">
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(".btn-submit").click(function(e){
        e.preventDefault();

        var name = $("input[name=name]").val();
        var email = $("input[name=email]").val();
        var phone = $("input[name=phone]").val();
        var message = $("textarea[name=message]").val();

        $.ajax({
           type:'POST',
           url:'/contact',
           data:{name:name, email:email, phone:phone, message:message},
           success: function(data) {
	                if($.isEmptyObject(data.error)){
	                	printMsg(data.success);
	                }else{
	                	printErrorMsg(data.error);
	                }
	            }
        });
        function printErrorMsg (msg) {
            $(".print-msg").css('display','none');
			$(".print-error-msg").find("ul").html('');
			$(".print-error-msg").css('display','block');
			$.each( msg, function( key, value ) {
				$(".print-error-msg").find("ul").append('<li>'+value+'</li>');
			});
        }
        function printMsg (msg) {
            document.getElementById("submit").disabled = true;
            $(".print-error-msg").css('display','none');
            $(".print-msg").css('display','block');
            $("#contactform")[0].reset();
        }




	});
</script>
@endsection
