@extends('layout')

@section('content')




<section class="padding-y-100 bg-light">
  <div class="container">
    <div class="row">
      <div class="col-lg-6 mx-auto">
        <div class="card shadow-v2"> 
         <div class="card-header border-bottom">
          <h4 class="mt-4">
            {{ __('messages.login') }}
          </h4>
         </div>         
          <div class="card-body">
            <form method="POST" action="{{ route('login') }}" aria-label="{{ __('messages.login') }}" class="px-lg-4">
                 @csrf


              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-email"></span>
                </div>
                <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}"  class="form-control border-left-0 pl-0" placeholder="{{ __('messages.mail') }}" required autofocus>
                @if ($errors->has('email'))
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif
              </div>


              <div class="input-group input-group--focus mb-3">
                <div class="input-group-prepend">
                  <span class="input-group-text bg-white ti-lock"></span>
                </div>
                <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password"  class="form-control border-left-0 pl-0" placeholder="{{ __('messages.password') }}" required>
                @if ($errors->has('password'))
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                @endif
              </div>


              <div class="d-md-flex justify-content-between my-4">
                <label class="ec-checkbox check-sm my-2 clearfix">
                  <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                  <span class="ec-checkbox__control"></span>
                  <span class="ec-checkbox__lebel">{{ __('messages.remember') }}</span>
                </label>
                <a href="{{ route('password.request') }}" class="text-primary my-2 d-block">{{ __('messages.forget_password') }}</a>
              </div>


              <button class="btn btn-block btn-primary" type="submit">{{ __('messages.login') }}</button>
              <p class="my-5 text-center">
                 {{ __('messages.register_text') }} <a href="{{ route('register') }}" class="text-primary">{{ __('messages.register') }}</a>
              </p>


            </form>
          </div>
        </div>
      </div> 
    </div> <!-- END row-->
  </div> <!-- END container-->
</section>

















@endsection
