<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Nicolaslopezj\Searchable\SearchableTrait;
use TCG\Voyager\Traits\Translatable;

class Product extends Model
{
    use SearchableTrait;
    use Translatable;
     protected $translatable = ['name','details','description'];

    protected $fillable = ['quantity'];

    /**
     * Searchable rules.
     *
     * @var array
     */
    protected $searchable = [
        /**
         * Columns and their priority in search results.
         * Columns with higher values are more important.
         * Columns with equal values have equal importance.
         *
         * @var array
         */
        'columns' => [
            'products.name' => 10,
            'products.details' => 5,
            'products.description' => 2,
        ],
    ];



    public function category()
    {
        return $this->belongsToMany('App\Category');
    }

    public function presentPrice()
    {
        $locale = app()->getLocale();
        if ($locale =='ar') {
        return number_format($this->price / 100, 2).'دينار';
        }else{
        return 'JD'.number_format($this->price / 100, 2);
        }
        
    }

     public function presentPrice2()
    {
        $locale = app()->getLocale();
        if ($locale =='ar') {
        return number_format($this->price / 100*1.5, 2).'دينار';
        }else{
        return 'JD'.number_format($this->price / 100*1.5, 2);
        }
    }

     public function scopeMightAlsoLike($query)
    {
    	return $query->inRandomOrder()->take(4);
    }
}
