<?php

namespace App\Http\Controllers;
use Lang;
use App\Product;
use App\Category;
use Illuminate\Http\Request;

class ShopController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function shop()
    {
        $locale = app()->getLocale();
        $fallbacklocale =\Config::get('app.fallback_locale');
        $pagination = 9;
        // $category = Category::all();
        $category = Category::with('translations')->get();

        if (request()->category) {
            $products = Product::with('translations')->with('category')->whereHas('category', function ($query) {
                $query->where('slug', request()->category);
            });

            // $categoryName = optional($category->where('slug', request()->category)->first())->name;
            $categoryName = optional($category->where('slug', request()->category)->first())->getTranslatedAttribute('name', $locale, $fallbacklocale);
        } else {
            $products = Product::with('translations')->where('featured', true);
            $categoryName = __('messages.featured');
        }

        if (request()->sort == 'low_high') {
            $products = $products->orderBy('price')->paginate($pagination);
        } elseif (request()->sort == 'high_low') {
            $products = $products->orderBy('price', 'desc')->paginate($pagination);
        } else {
            $products = $products->paginate($pagination);
        }
        
      
      $mightAlsoLike = Product::with('translations')->MightAlsoLike()->get();


      

      return view('shop')->with([
        'products'=> $products,
        'category' => $category,
        'categoryName' => $categoryName,
        'mightAlsoLike' => $mightAlsoLike,
        'locale' => $locale,
        'fall_back_locale' => $fallbacklocale,
    ]);
    }

     /**
     * Display the specified resource.
     *
     * @param  string  $slug
     * @return \Illuminate\Http\Response
     */
    public function show($slug)
    {
         $locale = app()->getLocale();
        $fallbacklocale =\Config::get('app.fallback_locale');
        $product = Product::with('translations')->where('slug', $slug)->firstOrFail();
        $mightAlsoLike = Product::with('translations')->where('slug', '!=', $slug)->MightAlsoLike()->get();

        $stockLevel = getStockLevel($product->quantity);


        return view('product')->with([
            'product' => $product,
            'stockLevel' => $stockLevel,
            'mightAlsoLike' => $mightAlsoLike,
            'locale' => $locale,
            'fall_back_locale' => $fallbacklocale,
        ]);
    }

    public function search(Request $request)
    {
        $request->validate([
            'query' => 'required|min:3',
        ]);

        $query = $request->input('query');

        $products = Product::where('name', 'like', "%$query%")
                           ->orWhere('details', 'like', "%$query%")
                           ->orWhere('description', 'like', "%$query%")
                           ->paginate(10);

        // $products = Product::search($query)->paginate(10);

        return view('search-results')->with('products', $products);
    }



}
