<?php

namespace App\Http\Controllers;

use Lang;
use App\Post;
use App\Slider;
use App\Service;
use App\Counter;
use App\Faq;
use App\Event;
use App\Gallery;
use App\ContactUS;
use Validator;
use Illuminate\Http\Request;

class MainPageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $sliders = Slider::with('translations')->orderBy('order')->where('visible', '1')->get();
      $events = Event::with('translations')->where('status', '1')->take(3)->get();
      $news = Post::with('translations')->where('status', 'published')->take(6)->get();
      $services = Service::with('translations')->take(9)->get();
      $counters = Counter::with('translations')->take(5)->get();
      $images = Gallery::take(15)->get();
      $locale = app()->getLocale();
      $fallbacklocale =\Config::get('app.fallback_locale');
      //dd($fallbacklocale);
      // $sliders = $sliders->translate($locale, $fallbacklocale);

      return view('main')->with([
        'sliders'=> $sliders,
        'services'=> $services,
        'counters'=> $counters,
        'events'=> $events,
         'news'=> $news,
         'images'=> $images,
        'locale' => $locale,
        'fall_back_locale' => $fallbacklocale,
    ]);
    }


    public function slider_single($id)
    {
        $locale = app()->getLocale();
        $fallbacklocale =\Config::get('app.fallback_locale');
        $slider_single = Slider::with('translations')->where('id', $id)->firstOrFail();

        return view('slider_single')->with([
            'slider_single' => $slider_single,
            'locale' => $locale,
            'fall_back_locale' => $fallbacklocale,
        ]);
    }


       /**
     * Display the specified resource.
     *
     * @param  string  $slug
     * @return \Illuminate\Http\Response
     */
     public function news()
    {
      $news = Post::with('translations')->where('status', 'published')->paginate(9);
      $locale = app()->getLocale();
      $fallbacklocale =\Config::get('app.fallback_locale');

      return view('news')->with([
        'news'=> $news,
        'locale' => $locale,
        'fall_back_locale' => $fallbacklocale,
    ]);
    }
         /**
     * Display the specified resource.
     *
     * @param  string  $slug
     * @return \Illuminate\Http\Response
     */
    public function news_single($slug)
    {
        $locale = app()->getLocale();
        $fallbacklocale =\Config::get('app.fallback_locale');
        $news_single = Post::with('translations')->where('slug', $slug)->firstOrFail();

        return view('news_single')->with([
            'news_single' => $news_single,
            'locale' => $locale,
            'fall_back_locale' => $fallbacklocale,
        ]);
    }



       /**
     * Display the specified resource.
     *
     * @param  string  $slug
     * @return \Illuminate\Http\Response
     */
     public function faq()
    {
      $faqs = Faq::with('translations')->get();

      $locale = app()->getLocale();
      $fallbacklocale =\Config::get('app.fallback_locale');

      return view('faqs')->with([
        'faqs'=> $faqs,
        'locale' => $locale,
        'fall_back_locale' => $fallbacklocale,
    ]);
    }




    /**
     * Display the specified resource.
     *
     * @param  string  $slug
     * @return \Illuminate\Http\Response
     */
     public function gallery()
    {

      $images = Gallery::paginate(16);

      $locale = app()->getLocale();
      $fallbacklocale =\Config::get('app.fallback_locale');

      // dd($images);

      return view('gallery')->with([
        'images'=> $images,
        'locale' => $locale,
        'fall_back_locale' => $fallbacklocale,
    ]);
    }




     /**
     * Display the specified resource.
     *
     * @param  string
     * @return \Illuminate\Http\Response
     */
    public function contact()
    {
        $locale = app()->getLocale();
        $fallbacklocale =\Config::get('app.fallback_locale');
        // $news_single = Post::with('translations')->where('slug', $slug)->firstOrFail();

        return view('contact')->with([
            'locale' => $locale,
            'fall_back_locale' => $fallbacklocale,
        ]);
    }

   /**
     * Display a listing of the myformPost.
     *
     * @return \Illuminate\Http\Response
     */
    public function contactp(Request $request)
    {
        // dd($request);
    	$validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'message' => 'required',
        ]);

        if ($validator->passes()) {
            ContactUS::create($request->all());
			return response()->json(['success'=>'Thanxs.']);
        }
    	return response()->json(['error'=>$validator->errors()->all()]);
    }


}
