<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Event;

class EventsController extends Controller
{
    /**
     * Display a listing of the resource.
     * param string  $slug
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $events = Event::with('translations')->where('status', '1')->paginate(9);
      $locale = app()->getLocale();
      $fallbacklocale =\Config::get('app.fallback_locale');

      return view('events')->with([
        'events'=> $events,
        'locale' => $locale,
        'fall_back_locale' => $fallbacklocale,
        ]);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $slug
     * @return \Illuminate\Http\Response
     */
    public function show($slug)
    {
        $locale = app()->getLocale();
        $fallbacklocale =\Config::get('app.fallback_locale');
        $event = Event::findBySlug($slug);
         return view('event')->with([
        'event'=> $event,
        'locale' => $locale,
        'fall_back_locale' => $fallbacklocale,
        ]);
    }




}
