var LoginPage = function () {
    var Loginvalidation = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var form3 = $('#LoginForm');
        var error3 = $('.alert-danger', form3);
        var success3 = $('.alert-success', form3);

        //IMPORTANT: update CKEDITOR textarea with actual content before submit
//            form3.on('submit', function() {
//                for(var instanceName in CKEDITOR.instances) {
//                    CKEDITOR.instances[instanceName].updateElement();
//                }
//            })

        form3.validate({
            lang: Lang.theLang,
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "", // validate all fields including form hidden input
            rules: {
                username: {
                    required: true,
                },
                password: {
                    required: true,
                },
            },
            messages: {// custom messages for radio buttons and checkboxes

            },
            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.parent(".input-group").size() > 0) {
                    error.insertAfter(element.parent(".input-group"));
                } else if (element.attr("data-error-container")) {
                    error.appendTo(element.attr("data-error-container"));
                } else if (element.parents('.radio-list').size() > 0) {
                    error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                } else if (element.parents('.radio-inline').size() > 0) {
                    error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                } else if (element.parents('.checkbox-list').size() > 0) {
                    error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                } else if (element.parents('.checkbox-inline').size() > 0) {
                    error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },
            invalidHandler: function (event, validator) { //display error alert on form submit   
                success3.addClass('hidden');
                error3.removeClass('hidden');

                $("html,body").animate({scrollTop: $('#LoginForm').offset().top - 100}, "slow");
                // $(".box-content").animate({ scrollTop: 0 }, "slow");
            },
            highlight: function (element) { // hightlight error inputs
                $(element).parent().addClass('has-error'); // set error class to the control group
            },
            unhighlight: function (element) { // revert the change done by hightlight
                $(element).parent().removeClass('has-error'); // set error class to the control group
            },
            success: function (label) {
                label.parent().removeClass('has-error'); // set success class to the control group
            },
            submitHandler: function (form) {
                success3.addClass('hidden');
                error3.addClass('hidden');
                var theForm = $('#LoginForm');
                //upload files
                var data = new FormData(theForm[0]);

//                jQuery.each(jQuery('#file')[0].files, function (i, file) {
//                    data.append('file-' + i, file);
//                });
                $.ajax({
                    type: "POST",
                    url: URLBase + "Login/ProcessLogin",
                    data: data,
                    //async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "JSON",
                    beforeSend: function () {
                        $.blockUI({
                            message: Lang.Please_wait,
                            css: {
                                border: 'none',
                                padding: '15px',
                                backgroundColor: '#000',
                                '-webkit-border-radius': '10px',
                                '-moz-border-radius': '10px',
                                opacity: .5,
                                color: '#fff'
                            }});
                        $("#LoginForm :input").prop("disabled", true);
                        $("#submit-buttons").addClass('hidden');
                    },
                    complete: function () {
                        $.unblockUI();
                        $("#LoginForm :input").prop("disabled", false);
                        $("#submit-buttons").removeClass('hidden');
                    },
                    success: function (response)
                    {
                        error3.addClass('hidden');
                        success3.addClass('hidden');

                        if (response !== null && response.hasOwnProperty("Errors")) {
                            //console.log(response['Errors']);
                            var obj = response["Errors"];

                            $('#Server_alerts').html(obj);
                            $('.Server_alerts').removeClass('hidden');

                        } else if (response !== null && response.hasOwnProperty("Success")) {
                            $('.Server_alerts').addClass('hidden');
                            Success = response.Success;
                            $('#LoginForm').html('');
                            if (response.Success === 'redirect') {
                                if (response.hasOwnProperty("redirect_url")) {
                                    window.location.replace(response.redirect_url);
                                } else {
                                    location.reload();
                                }
                            }


                        }
                    }
                });
                //form[0].submit(); // submit the form
            }

        });

        //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
        $('.select2', form3).change(function () {
            form3.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
        });

    }
    return {
        //main function to initiate the module
        init: function () {
            Loginvalidation();
        }

    };

}();

jQuery(document).ready(function () {
    LoginPage.init();
});