var WVoices = function () {

    var initPickers = function () {
        //init date pickers
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true,
            language: $('html').attr('lang')
        });
    };

    var handleRecords = function () {
        var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": Lang['Please_wait'],
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };
        var grid = new Datatable();

        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: Lang.Please_wait,
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

                "lengthMenu": [
                    [10, 20, 50, 100, 150, -1],
                    [10, 20, 50, 100, 150, "All"] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "ajax": {
                    "url": URLBase + "Uploadcenter/GetData", // ajax source
                },
                "order": [
                    [1, "desc"]
                ], // set first column as a default sort by asc
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': "_all"
                    },
                ]
            }
        });

        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() !== "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
                //refresh table
                var table = $('#datatable_ajax').DataTable();
                table.ajax.reload();
            } else if (action.val() === "") {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['Please_select_an_action'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['No_record_selected'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });

        grid.setAjaxParam("customActionType", "group_action");
        // grid.getDataTable().ajax.reload();
        grid.clearAjaxParams();
    }
    var select2_multiple = function () {
        $(".select2-multiple").select2({
            placeholder: '...',
            width: null
        });
    };


    var handleValidation3 = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var form3 = $('#SForm');
        var error3 = $('.alert-danger', form3);

        //IMPORTANT: update CKEDITOR textarea with actual content before submit
        form3.on('submit', function () {
            for (var instanceName in CKEDITOR.instances) {
                CKEDITOR.instances[instanceName].updateElement();
            }
        })

        form3.validate({
            lang: Lang.theLang,
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "", // validate all fields including form hidden input
            rules: {
                file_path: {
                    required: true,
                    extension: "pdf|doc|docx|xls|xlsx|ppt|pptx"
                },

                title_ar: {
                    required: true,
                    maxlength: 255,
                },
                title_en: {
                    required: true,
                    maxlength: 255,
                },



            },
            messages: {// custom messages for radio buttons and checkboxes

            },
            errorPlacement: function (error, element) { // render error placement for each input type
                if (element.parent(".input-group").size() > 0) {
                    error.insertAfter(element.parent(".input-group"));
                } else if (element.attr("data-error-container")) {
                    error.appendTo(element.attr("data-error-container"));
                } else if (element.parents('.radio-list').size() > 0) {
                    error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                } else if (element.parents('.radio-inline').size() > 0) {
                    error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                } else if (element.parents('.checkbox-list').size() > 0) {
                    error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                } else if (element.parents('.checkbox-inline').size() > 0) {
                    error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                } else {
                    error.insertAfter(element); // for other inputs, just perform default behavior
                }
            },
            invalidHandler: function (event, validator) { //display error alert on form submit   
                error3.show();
                App.scrollTo(error3, -200);
            },
            highlight: function (element) { // hightlight error inputs
                $(element)
                        .parent().addClass('has-error'); // set error class to the control group
            },
            unhighlight: function (element) { // revert the change done by hightlight
                $(element)
                        .parent().removeClass('has-error'); // set error class to the control group
            },
            success: function (label) {
                label
                        .parent().removeClass('has-error'); // set success class to the control group
            },
            submitHandler: function (form) {
                error3.hide();

                //upload files
                var data = new FormData(form3[0]);
                jQuery.each(jQuery('.file')[0].files, function (i, file) {
                    data.append('file-' + i, file);
                });
                data.append('par1', form3.attr("par1"));
                data.append('par2', form3.attr("par2"));
                $.ajax({
                    type: "POST",
                    url: URLBase + "Uploadcenter/ToDB",
                    data: data,
                    //async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "JSON",
                    beforeSend: function () {
                        $("#SForm :input").prop("disabled", true);
                        $("#submit-buttons").addClass('hidden');
                        $("#spinner").removeClass('hidden');
                        App.blockUI({
                            target: '#SForm',
                            overlayColor: 'none',
                            cenrerY: true,
                            animate: true
                        });
                    },
                    complete: function () {
                        $("#SForm :input").prop("disabled", false);
                        $("#submit-buttons").removeClass('hidden');
                        $("#spinner").addClass('hidden');
                        App.unblockUI('#SForm');
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        $.alert({
                            title: Lang.Error,
                            content: xhr.status + " - " + thrownError,
                            type: 'red',
                            rtl: App.isRTL(),
                            closeIcon: true,
                            buttons: {
                                cancel: {
                                    text: Lang.Ok,
                                    action: function () {
                                    }
                                }
                            }
                        });
                    },
                    success: function (response)
                    {
                        if (response !== null && response.hasOwnProperty("Errors")) {
                            var Res = response.Errors;
                            $.alert({
                                title: Res.title,
                                content: Res.content,
                                type: 'red',
                                rtl: App.isRTL(),
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,

                                        action: function () {

                                        }

                                    }
                                }
                            });

                        } else if (response !== null && response.hasOwnProperty("Success")) {
                            var Res = response.Success;
                            $.alert({
                                title: Res.title,
                                content: Res.content,
                                type: 'green',
                                rtl: App.isRTL(),
                                autoClose: 'cancel|3000',
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,

                                        action: function () {
                                            if (Res.hasOwnProperty("redirect_url")) {
                                                window.location.replace(Res.redirect_url);
                                            }
                                        }

                                    }
                                }
                            });

                        }
                    }
                });
                //form[0].submit(); // submit the form
            }

        });

        //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
        $('.select2me', form3).change(function () {
            form3.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
        });

        //initialize datepicker
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true,
            language: $('html').attr('lang')
        });
        $('.date-picker .form-control').change(function () {
            form3.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input 
        })
    }
    var PageMethods = function () {
        $(document).on('click', '.Delete', function () {
            var el = $(this);
            DeleteItemAjax(el, "Uploadcenter/Delete");

        });

    }
    return {
        //main function to initiate the module
        init: function () {
            select2_multiple();
            handleValidation3();
            initPickers();
            handleRecords();
            PageMethods();

        }

    };

}();



jQuery(document).ready(function () {
    WVoices.init();
});