var TableDatatablesAjax = function () {

    var initPickers = function () {
        //init date pickers
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            autoclose: true
        });
    };

    var AllRegSectionsTable = function () {
        var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": Lang['Please_wait'],
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };
        var grid = new Datatable();

        grid.init({
            src: $("#AllRegSectionsTable"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  

            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load


            },
            loadingMessage: Lang.Please_wait,
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

                "lengthMenu": [
                    [10, 20, 50, 100, 150, -1],
                    [10, 20, 50, 100, 150, "All"] // change per page values here
                ],
                "pageLength": 10, // default record count per page
                "bSort": false,
                "paging": false,
                "ajax": {
                    "url": URLBase + "Teacher_Counseling/GetStudentSections", // ajax source
                },
                "order": [
                    [1, "desc"]
                ], // set first column as a default sort by asc
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [0]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [1]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [2]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [3]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [4]
                    },
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': [5]
                    },
                ]
            }
        });
        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() !== "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
                //refresh table
                var table = $('#AllRegSectionsTable').DataTable();
                table.ajax.reload();

            } else if (action.val() === "") {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['Please_select_an_action'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['No_record_selected'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });

        grid.setAjaxParam("customActionType", "group_action");
        // grid.getDataTable().ajax.reload();
        grid.clearAjaxParams();
    }
    var PageMethods = function () {

        $(document).on('click', '.Approve', function () {
            var el = $(this);
            $.ajax({
                type: "POST",
                url: URLBase + "Teacher_Counseling/ApproveSection",
                data: {id: el.attr('par1'), student: el.attr('par2')},
                //async: false,
                dataType: "JSON",
                beforeSend: function () {

                    App.blockUI({
                        target: '#AllRegSectionsTable',
                        overlayColor: 'none',
                        cenrerY: true,
                        animate: true
                    });
                },
                complete: function () {
                    App.unblockUI('#AllRegSectionsTable');
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    $.alert({
                        title: Lang.Error,
                        content: xhr.status + " - " + thrownError,
                        type: 'red',
                        rtl: true,
                        closeIcon: true,
                        buttons: {
                            cancel: {
                                text: Lang.Ok,
                                action: function () {
                                }
                            }
                        }
                    });
                },
                success: function (response)
                {
                    if (response !== null && response.hasOwnProperty("Resp")) {

                        var table = $('#AllRegSectionsTable').DataTable();
                        table.ajax.reload();



                        var Res = response['Resp'];
                        UINotific8.init(Res.theme, Res.horizontalEdge, Res.verticalEdge, Res.heading, Res.life, Res.text);
                    }
                }

            });

        });

        $(document).on('click', '.Delete', function () {
            var el = $(this);

            $.confirm({
                title: el.attr('Dtitle'),
                content: el.attr('Dcontent'),
                type: 'red',
                buttons: {
                    confirm: {
                        text: el.attr('confirmButton'),
                        btnClass: 'btn-danger',
                        keys: ['enter'],
                        action: function () {
                            $.ajax({
                                type: "POST",
                                url: URLBase + "Teacher_Counseling/DeleteSectionRel",
                                data: {id: el.attr('par1'), student: el.attr('par2')},
                                //async: false,
                                dataType: "JSON",
                                beforeSend: function () {
                                    App.blockUI({
                                        target: '#AllRegSectionsTable',
                                        overlayColor: 'none',
                                        cenrerY: true,
                                        animate: true
                                    });
                                },
                                complete: function () {
                                    App.unblockUI('#AllRegSectionsTable');
                                },
                                error: function (xhr, ajaxOptions, thrownError) {
                                    $.alert({
                                        title: Lang.Error,
                                        content: xhr.status + " - " + thrownError,
                                        type: 'red',
                                        rtl: App.isRTL(),
                                        closeIcon: true,
                                        buttons: {
                                            cancel: {
                                                text: Lang.Ok,
                                                action: function () {
                                                }
                                            }
                                        }
                                    });
                                },
                                success: function (response)
                                {
                                    if (response !== null && response.hasOwnProperty("Resp")) {

                                        //refresh table
                                        var table = $('#AllRegSectionsTable').DataTable();
                                        table.ajax.reload();


                                        var Res = response['Resp'];
                                        UINotific8.init(Res.theme, Res.horizontalEdge, Res.verticalEdge, Res.heading, Res.life, Res.text);
                                    }
                                }
                            });
                        }
                    },
                    cancel: {
                        text: el.attr('cancelButton'),
                        keys: ['esc'],
                        action: function () {
                        }
                    },
                }
            });


        });

        $(document).on('click', '.ReJectSection', function () {
            var el = $(this);
            $.confirm({
                title: el.attr('Dtitle'),
                content: el.attr('Dcontent') +
                        '<div style="margin:5px 0px;"><textarea  placeholder="' + el.attr("PHold") + '" rows="3" class="notes form-control"></textarea></div>',
                buttons: {
                    formSubmit: {
                        text: el.attr("Submit_Btn"),
                        btnClass: 'btn-red',
                        action: function () {
                            var notes = this.$content.find('.notes').val();
                            ///
                            $.ajax({
                                type: "POST",
                                url: URLBase + "Teacher_Counseling/ReJectSection",
                                data: {par1: el.attr('par1'), notes: notes},
                                //async: false,
                                dataType: "JSON",
                                beforeSend: function () {
                                    App.blockUI({
                                        target: '.jconfirm',
                                        overlayColor: 'none',
                                        cenrerY: true,
                                        animate: true
                                    });
                                },
                                complete: function () {
                                    App.unblockUI('.jconfirm');
                                },
                                error: function (xhr, ajaxOptions, thrownError) {
                                    $.alert({
                                        title: Lang.Error,
                                        content: xhr.status + " - " + thrownError,
                                        type: 'red',
                                        rtl: App.isRTL(),
                                        closeIcon: true,
                                        buttons: {
                                            cancel: {
                                                text: Lang.Ok,
                                                action: function () {
                                                }
                                            }
                                        }
                                    });
                                },
                                success: function (response)
                                {
                                    if (response !== null && response.hasOwnProperty("Errors")) {
                                        var Res = response['Errors'];

                                        $.alert({
                                            title: Res.title,
                                            content: Res.content,
                                            autoClose: 'cancel|10000',
                                            type: 'red',
                                            rtl: App.isRTL(),
                                            closeIcon: true,
                                            buttons: {
                                                cancel: {
                                                    text: Lang.Ok,
                                                    action: function () {
                                                        //refresh table
                                                        if ($('#datatable_ajax').length) {
                                                            var table = $('#datatable_ajax').DataTable();
                                                            table.ajax.reload();
                                                        } else {
                                                            location.reload();
                                                        }
                                                    }
                                                }
                                            }
                                        });

                                    } else   if (response !== null && response.hasOwnProperty("Resp")) {

                        var table = $('#AllRegSectionsTable').DataTable();
                        table.ajax.reload();



                        var Res = response['Resp'];
                        UINotific8.init(Res.theme, Res.horizontalEdge, Res.verticalEdge, Res.heading, Res.life, Res.text);
                    }
                                }
                            });
                        }
                    },
                    cancel: {
                        text: el.attr("Cancel_Btn"),
                        action: function () {

                        }
                    }
                },
                onContentReady: function () {
                    // bind to events
                    var jc = this;
                    this.$content.find('form').on('submit', function (e) {
                        // if the user submits the form by pressing enter in the field.
                        e.preventDefault();
                        jc.$$formSubmit.trigger('click'); // reference the button and click it
                    });
                }
            });



        });
    }
    return {
        //main function to initiate the module
        init: function () {

            initPickers();
            AllRegSectionsTable();
            PageMethods();

        }

    };

}();


jQuery(document).ready(function () {
    TableDatatablesAjax.init();
});