var Stores_Goods_Receipts = function () {
    //BarCode Select Begin
    var BarCode_Select = function (Selector) {
        Selector.select2({
            width: "off",
            language: Lang.theLang,
            ajax: {
                url: URLBase + "Stores_Goods_Receipts/GetStoresItems",
                type: "POST",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        BarCode: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data, page) {
                    // parse the results into the format expected by Select2.
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data
                    return {
                        results: data.items
                    };
                },
                cache: false
            },
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
            minimumInputLength: 1,
            templateResult: function (repo) {
                if (repo.loading) {
                    return repo.text;
                }
                var markup = "<div>";
                if (repo.name) {
                    markup += "<div class='select2-result-repository__description'>" + repo.barcode + "</div>";
                }
                markup += "<div class='select2-result-repository__statistics'>" +
                        "<div class='select2-result-repository__forks'> " + repo.name + " </div>" +
                        "</div>" +
                        "</div></div>";
                return markup;
            },
            templateSelection: function (repo) {

                if (repo.barcode) {

                    //تغير حقل الصنف
                    var Store = Selector.parent().parent().parent().find('select.Item_Select');
                    if (Store.length) {
                        Store.append('<option value="' + repo.id + '">' + repo.name + '</option>')
                        Store.val(repo.id).trigger("change");
                    }
                    //تغير حقل الباركود
                    var ItemNumber = Selector.parent().parent().parent().find('select.ItemNumber_Select');
                    if (ItemNumber.length) {
                        ItemNumber.append('<option value="' + repo.id + '">' + repo.number + '</option>')
                        ItemNumber.val(repo.id).trigger("change");
                    }
                    //تغير حقل الكمية الحالية
                    var current_qty = Selector.parent().parent().parent().find('input.current_qty');
                    if (current_qty.length) {
                        current_qty.val(repo.current_qty);
                    }

                    return  repo.barcode;
                } else {
                    return  repo.text;
                }
            }
        });
    };
    //End Select Begin
    //ItemNumber Select Begin
    var ItemNumber_Select = function (Selector) {
        Selector.select2({
            width: "off",
            language: Lang.theLang,
            ajax: {
                url: URLBase + "Stores_Goods_Receipts/GetStoresItems",
                type: "POST",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        ItemNumber: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data, page) {
                    // parse the results into the format expected by Select2.
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data
                    return {
                        results: data.items
                    };
                },
                cache: false
            },
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
            minimumInputLength: 1,
            templateResult: function (repo) {
                if (repo.loading) {
                    return repo.text;
                }
                var markup = "<div>";
                if (repo.name) {
                    markup += "<div class='select2-result-repository__description'>" + repo.number + "</div>";
                }
                markup += "<div class='select2-result-repository__statistics'>" +
                        "<div class='select2-result-repository__forks'> " + repo.name + " </div>" +
                        "</div>" +
                        "</div></div>";
                return markup;
            },
            templateSelection: function (repo) {

                if (repo.number) {
                    //تغير حقل الصنف
                    var Store = Selector.parent().parent().parent().find('select.Item_Select');
                    if (Store.length) {
                        Store.append('<option value="' + repo.id + '">' + repo.name + '</option>')
                        Store.val(repo.id).trigger("change");
                    }
                    //تغير حقل الباركود
                    var Barcode = Selector.parent().parent().parent().find('select.BarCode_Select');
                    if (Barcode.length) {
                        Barcode.append('<option value="' + repo.id + '">' + repo.barcode + '</option>')
                        Barcode.val(repo.id).trigger("change");
                    }
                    //تغير حقل الكمية الحالية
                    var current_qty = Selector.parent().parent().parent().find('input.current_qty');
                    if (current_qty.length) {
                        current_qty.val(repo.current_qty);
                    }


                    return  repo.number;
                } else {
                    return  repo.text;
                }
            }
        });
    };
    //End Select 
    //Item Select Begin
    var Item_Select = function (Selector) {
        Selector.select2({
            width: "off",
            language: Lang.theLang,
            ajax: {
                url: URLBase + "Stores_Goods_Receipts/GetStoresItems",
                type: "POST",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        Item: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data, page) {
                    // parse the results into the format expected by Select2.
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data
                    return {
                        results: data.items
                    };
                },
                cache: false
            },
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
            minimumInputLength: 1,
            templateResult: function (repo) {
                if (repo.loading) {
                    return repo.text;
                }
                var markup = "<div>";
                if (repo.name) {
                    markup += "<div class='select2-result-repository__description'>" + repo.name + "</div>";
                }
                markup += "<div class='select2-result-repository__statistics'>" +
                        "<div class='select2-result-repository__forks'> " + repo.name + " </div>" +
                        "</div>" +
                        "</div></div>";
                return markup;
            },
            templateSelection: function (repo) {

                if (repo.barcode) {
                    //تغير حقل رقم المادة
                    var ItemNumber = Selector.parent().parent().parent().find('select.ItemNumber_Select');
                    if (ItemNumber.length) {
                        ItemNumber.append('<option value="' + repo.id + '">' + repo.number + '</option>')
                        ItemNumber.val(repo.id).trigger("change");
                    }
                    //تغير حقل الباركود
                    var Barcode = Selector.parent().parent().parent().find('select.BarCode_Select');
                    if (Barcode.length) {
                        Barcode.append('<option value="' + repo.id + '">' + repo.barcode + '</option>')
                        Barcode.val(repo.id).trigger("change");
                    }
                    //تغير حقل الكمية الحالية
                    var current_qty = Selector.parent().parent().parent().find('input.current_qty');
                    
                    if (current_qty.length) {
                        
                        current_qty.val(repo.current_qty);
                    }


                    return  repo.name;
                } else {
                    return  repo.text;
                }
            }
        });
    };
    //End Select 
    //Supplier Select
    var supplier_Select = function (Selector) {
        Selector.select2({
            width: "off",
            language: Lang.theLang,
            ajax: {
                url: URLBase + "Stores_Goods_Receipts/GetSuppliers",
                type: "POST",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        name: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data, page) {
                    // parse the results into the format expected by Select2.
                    // since we are using custom formatting functions we do not need to
                    // alter the remote JSON data
                    return {
                        results: data.items
                    };
                },
                cache: false
            },
            escapeMarkup: function (markup) {
                return markup;
            }, // let our custom formatter work
            minimumInputLength: 2,
            templateResult: function (repo) {
                if (repo.loading) {
                    return repo.text;
                }
                var markup = "<div>";
                if (repo.name) {
                    markup += "<div class='select2-result-repository__description'>" + repo.name + "</div>";
                }
                markup += "<div class='select2-result-repository__statistics'>" +
                        "<div class='select2-result-repository__forks'> " + repo.name + " </div>" +
                        "</div>" +
                        "</div></div>";
                return markup;
            },
            templateSelection: function (repo) {

                if (repo.name) {
                    return  repo.name;
                } else {
                    return  repo.text;
                }
            }
        });
    };
    //End Supplier Select 

    var initPickers = function () {

        //init date pickers
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            language: Lang.theLang,
            autoclose: true
        });



    };
    var handleRecords = function () {



        var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": Lang['Please_wait'],
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };
        var grid = new Datatable();

        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: Lang.Please_wait,
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bStateSave": true, // save datatable state(pagination, sort, etc) in cookie.

                "lengthMenu": [
                    [10, 20, 50, 100, 150, -1],
                    [10, 20, 50, 100, 150, "All"] // change per page values here
                ],
                "pageLength": 10, // default record count per page

                "ajax": {
                    "url": URLBase + "Stores_Goods_Receipts/GetData", // ajax source
                },
                "order": [
                    [1, "desc"]
                ], // set first column as a default sort by asc
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': "_all"
                    },
                ]
            }
        });
        //لتحديث الجدول عند تغيير اي قيمة في الفلاتر
        // handle filter on change
        grid.getTableWrapper().on('change', '.onchange-submit', function (e) {
            e.preventDefault();
            grid.submitFilter();
        });

        // handle group actionsubmit button click
        grid.getTableWrapper().on('click', '.table-group-action-submit', function (e) {
            e.preventDefault();
            var action = $(".table-group-action-input", grid.getTableWrapper());
            if (action.val() !== "" && grid.getSelectedRowsCount() > 0) {
                grid.setAjaxParam("customActionType", "group_action");
                grid.setAjaxParam("customActionName", action.val());
                grid.setAjaxParam("id", grid.getSelectedRows());
                grid.getDataTable().ajax.reload();
                grid.clearAjaxParams();
                //refresh table
                var table = $('#datatable_ajax').DataTable();
                table.ajax.reload();
            } else if (action.val() === "") {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['Please_select_an_action'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            } else if (grid.getSelectedRowsCount() === 0) {
                App.alert({
                    type: 'danger',
                    icon: 'warning',
                    message: Lang['No_record_selected'],
                    container: grid.getTableWrapper(),
                    place: 'prepend'
                });
            }
        });

        grid.setAjaxParam("customActionType", "group_action");
        // grid.getDataTable().ajax.reload();
        grid.clearAjaxParams();
    }
    var repeater = function () {

        $('.mt-repeater').each(function () {
            $(this).repeater({
                show: function () {
                    $(this).slideDown();

                    $(this).find('.BarCode_Select').each(function (i, obj) {
                        BarCode_Select($(obj));
                    });
                    $(this).find('.ItemNumber_Select').each(function (i, obj) {
                        ItemNumber_Select($(obj));
                    });
                    $(this).find('.Item_Select').each(function (i, obj) {
                        Item_Select($(obj));
                    });

                },
                hide: function (deleteElement) {
                    var tt = $(this);
                    var el = $(this).find(".mt-repeater-del-right");
                    if (el.attr('par1')) {
                        $.confirm({
                            title: el.attr('Dtitle'),
                            content: el.attr('Dcontent'),
                            type: 'red',
                            buttons: {
                                confirm: {
                                    text: el.attr('confirmButton'),
                                    btnClass: 'btn-danger',
                                    keys: ['enter'],
                                    action: function () {
                                        $.ajax({
                                            type: "POST",
                                            url: URLBase + "Stores_Goods_Receipts/DeleteDetails",
                                            data: {id: el.attr('par1'), par2: el.attr('par2')},
                                            //async: false,
                                            dataType: "JSON",
                                            beforeSend: function () {
                                                App.blockUI({
                                                    target: '#SForm',
                                                    overlayColor: 'none',
                                                    cenrerY: true,
                                                    animate: true
                                                });
                                            },
                                            complete: function () {
                                                App.unblockUI('#SForm');
                                            },
                                            error: function (xhr, ajaxOptions, thrownError) {
                                                $.alert({
                                                    title: Lang.Error,
                                                    content: xhr.status + " - " + thrownError,
                                                    type: 'red',
                                                    rtl: App.isRTL(),
                                                    closeIcon: true,
                                                    buttons: {
                                                        cancel: {
                                                            text: Lang.Ok,
                                                            action: function () {
                                                            }
                                                        }
                                                    }
                                                });
                                            },
                                            success: function (response)
                                            {
                                                if (response !== null && response.hasOwnProperty("Success")) {
                                                    tt.slideUp(deleteElement);

                                                    var Res = response['Success'];
                                                    $.alert({
                                                        title: Res.title,
                                                        content: Res.content,
                                                        autoClose: 'cancel|10000',
                                                        type: 'green',
                                                        rtl: App.isRTL(),
                                                        closeIcon: true,
                                                        buttons: {
                                                            cancel: {
                                                                text: Lang.Ok,
                                                                action: function () {
                                                                }
                                                            }
                                                        }
                                                    });

                                                } else if (response !== null && response.hasOwnProperty("Errors")) {

                                                    var Error = response['Errors'];
                                                    $.alert({
                                                        title: Error.title,
                                                        content: Error.content,
                                                        type: 'red',
                                                        rtl: App.isRTL(),
                                                        closeIcon: true,
                                                        buttons: {
                                                            cancel: {
                                                                text: Lang.Ok,
                                                                action: function () {
                                                                }
                                                            }
                                                        }
                                                    });

                                                }
                                            }
                                        });
                                    }
                                },
                                cancel: {
                                    text: el.attr('cancelButton'),
                                    keys: ['esc'],
                                    action: function () {
                                    }
                                },
                            }
                        });
                    } else {
                        $.confirm({
                            title: el.attr('Dtitle'),
                            content: el.attr('Dcontent'),
                            type: 'red',
                            buttons: {
                                confirm: {
                                    text: el.attr('confirmButton'),
                                    btnClass: 'btn-danger',
                                    keys: ['enter'],
                                    action: function () {
                                        tt.slideUp(deleteElement);
                                    }
                                },
                                cancel: {
                                    text: el.attr('cancelButton'),
                                    keys: ['esc'],
                                    action: function () {
                                    }
                                },
                            }
                        });
                    }


                },
                ready: function (setIndexes) {
                    setIndexes;

                }

            });
        });


        $(document).on('change', '.item-inventory', function () {
            var el = $(this);
            var id_of_option = el.val();
            var parent = $(this).parent().parent().parent();
            var data = new FormData();
            data.append('id', id_of_option);
            data.append('type', 'Select');
            $.ajax({
                type: "POST",
                url: URLBase + "Stores_Goods_Receipts/GetItemAjax",
                data: data,
                async: false,
                cache: false,
                contentType: false,
                processData: false,
                dataType: "JSON",
                beforeSend: function () {
                    parent.block({
                        message: Lang.Please_wait,
                        css: {
                            border: 'none',
                            padding: '15px',
                            backgroundColor: '#000',
                            '-webkit-border-radius': '10px',
                            '-moz-border-radius': '10px',
                            opacity: .5,
                            color: '#fff'
                        }});
                },
                complete: function () {
                    parent.unblock();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    $.alert({
                        title: Lang.Error,
                        content: xhr.status + " - " + thrownError,
                        type: 'red',
                        rtl: App.isRTL(),
                        closeIcon: true,
                        buttons: {
                            cancel: {
                                text: Lang.Ok,
                                action: function () {
                                }
                            }
                        }
                    });
                },
                success: function (response)
                {


                    if (response !== null && response.hasOwnProperty("Success")) {
                        Success = response.Success;
                        if (parent.find('input.item_number').length !== 0) {

                            parent.find('input.item_number').val(Success.item_number);
                        }

                        if (parent.find('input.barcode').length !== 0) {
                            parent.find('input.barcode').val(Success.barcode);
                        }


                    }
                }
            });







        });
    };
    var Delete = function () {
        $(document).on('click', '.Delete', function () {
            var el = $(this);
            DeleteItemAjax(el, "Stores_Goods_Receipts/Delete");

        });
    }
    var DetectChangeOf_type_of_Deliverer = function () {
        $("select[name*='deliverer_type']").on("change", function () {
            var id = parseInt($(this).val());
            if (id === 1) {

                $("select[name*='employee']").prop("disabled", true);
                $("select[name*='employee']").parent().parent().addClass('hidden');
                $("select[name*='employee']").rules("remove"); //Delete all rules of this item
                if ($("select[name*='employee']").parent().prev().find('span.required').length !== 0) { //للتاكد انه  في نجمة
                    $("select[name*='employee']").parent().prev().find('span.required').remove();
                }

                $("select[name*='supplier']").prop("disabled", false);
                $("select[name*='supplier']").parent().parent().removeClass('hidden');
                $("select[name*='supplier']").rules("add", {
                    required: true
                }); //add the rules of this item
                if ($("select[name*='supplier']").parent().prev().find('span.required').length == 0) { //للتاكد انه ما في نجمة
                    $("select[name*='supplier']").parent().prev().append(' <span class="required" aria-required="true"> * </span>');
                }


            } else if (id === 2) {

                $("select[name*='supplier']").prop("disabled", true);
                $("select[name*='supplier']").parent().parent().addClass('hidden');
                $("select[name*='supplier']").rules("remove"); //Delete all rules of this item
                if ($("select[name*='supplier']").parent().prev().find('span.required').length !== 0) { //للتاكد انه  في نجمة
                    $("select[name*='supplier']").parent().prev().find('span.required').remove();
                }

                $("select[name*='employee']").prop("disabled", false);
                $("select[name*='employee']").parent().parent().removeClass('hidden');
                $("select[name*='employee']").rules("add", {
                    required: true
                }); //add the rules of this item
                if ($("select[name*='employee']").parent().prev().find('span.required').length == 0) { //للتاكد انه ما في نجمة
                    $("select[name*='employee']").parent().prev().append(' <span class="required" aria-required="true"> * </span>');
                }

            } else {

            }

        });
    }
    var FormValidation = function () {
        // for more info visit the official plugin documentation: 
        // http://docs.jquery.com/Plugins/Validation

        var form3 = $('#SForm');
        if (form3.length) {
            DetectChangeOf_type_of_Deliverer();
            var error3 = $('.alert-danger', form3);
            var success3 = $('.alert-success', form3);

            //IMPORTANT: update CKEDITOR textarea with actual content before submit
//        form3.on('submit', function () {
//            for (var instanceName in CKEDITOR.instances) {
//                CKEDITOR.instances[instanceName].updateElement();
//            }
//        })
            form3.on('submit', function () {
                CheckItems();
            });


            form3.validate({
                lang: Lang.theLang,
                errorElement: 'span', //default input error message container
                errorClass: 'help-block help-block-error', // default input error message class
                focusInvalid: false, // do not focus the last invalid input
                ignore: "", // validate all fields including form hidden input
                rules: {
                    store: {
                        required: true
                    },
                    supplier: {
                        required: true
                    },

                },
                messages: {// custom messages for radio buttons and checkboxes

                },
                errorPlacement: function (error, element) { // render error placement for each input type
                    if (element.parent(".input-group").size() > 0) {
                        error.insertAfter(element.parent(".input-group"));
                    } else if (element.attr("data-error-container")) {
                        error.appendTo(element.attr("data-error-container"));
                    } else if (element.parents('.radio-list').size() > 0) {
                        error.appendTo(element.parents('.radio-list').attr("data-error-container"));
                    } else if (element.parents('.radio-inline').size() > 0) {
                        error.appendTo(element.parents('.radio-inline').attr("data-error-container"));
                    } else if (element.parents('.checkbox-list').size() > 0) {
                        error.appendTo(element.parents('.checkbox-list').attr("data-error-container"));
                    } else if (element.parents('.checkbox-inline').size() > 0) {
                        error.appendTo(element.parents('.checkbox-inline').attr("data-error-container"));
                    } else {
                        error.insertAfter(element); // for other inputs, just perform default behavior
                    }

                },
                invalidHandler: function (event, validator) { //display error alert on form submit   
                    success3.hide();
                    error3.show();
                    App.scrollTo(error3, -200);
                },
                highlight: function (element) { // hightlight error inputs
                    $(element)
                            .parent().addClass('has-error'); // set error class to the control group
                },
                unhighlight: function (element) { // revert the change done by hightlight
                    $(element)
                            .parent().removeClass('has-error'); // set error class to the control group
                },
                success: function (label) {
                    label
                            .parent().removeClass('has-error'); // set success class to the control group
                },
                submitHandler: function (form) {
                    success3.hide();
                    error3.hide();



                    //upload files
                    var data = new FormData(form3[0]);
                    if ($('.file').length) {
                        $.each($('.file')[0].files, function (i, file) {
                            data.append('file-' + i, file);
                        });
                    }
                    data.append('par1', form3.attr("par1"));
                    data.append('par2', form3.attr("par2"));

                    $.ajax({
                        type: "POST",
                        url: URLBase + "Stores_Goods_Receipts/ReciptsToDB",
                        data: data,
                        //async: false,
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: "JSON",
                        beforeSend: function () {

                            $("#submit-buttons").addClass('hidden');
                            $("#spinner").removeClass('hidden');
                            App.blockUI({
                                target: '#SForm',
                                overlayColor: 'none',
                                cenrerY: true,
                                animate: true
                            });
                        },
                        complete: function () {
                            $("#submit-buttons").removeClass('hidden');
                            $("#spinner").addClass('hidden');
                            App.unblockUI('#SForm');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            $.alert({
                                title: Lang.Error,
                                content: xhr.status + " - " + thrownError,
                                type: 'red',
                                rtl: App.isRTL(),
                                closeIcon: true,
                                buttons: {
                                    cancel: {
                                        text: Lang.Ok,
                                        action: function () {
                                        }
                                    }
                                }
                            });
                        },
                        success: function (response)
                        {
                            if (response !== null && response.hasOwnProperty("Errors")) {
                                success3.hide();
                                var Errors = response.Errors;
                                $.alert({
                                    title: Errors.title,
                                    content: Errors.content,
                                    type: 'red',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                            }
                                        }
                                    }
                                });

                            } else if (response !== null && response.hasOwnProperty("Success")) {
                                $('.Server_alerts').addClass('hidden');
                                $("#submit-buttons").remove();
                                var Res = response['Success'];


                                $.alert({
                                    title: Res.title,
                                    content: Res.content,
                                    type: 'green',
                                    rtl: App.isRTL(),
                                    closeIcon: true,
                                    autoClose: 'cancel|3000',
                                    buttons: {
                                        cancel: {
                                            text: Lang.Ok,
                                            action: function () {
                                                window.location.replace(Res.redirect);
                                            }
                                        }
                                    }
                                });


                            }
                        }
                    });
                    //form[0].submit(); // submit the form
                }

            });
            function CheckItems() {
                $('.items').each(function (index) {
                    var itt = $(this);
                    var do_rule = false;
                    $('input,select', $(this)).each(function () {
                        if ($(this).val().length != 0) {
                            do_rule = true;
                        }
                    });
                    if (do_rule === true) {

                        $("input[name*='quantity']", itt).rules('add', {
                            "required": true,
                            "number": true
                        });
                        $("select[name*='item']", itt).rules('add', {
                            "required": true,
                            "number": true,
                        });
//                    $("select[name*='country']", itt).rules('add', {
//                        "required": true,
//                        "number": true,
//                    });
//                    $("input[name*='grade']", itt).rules('add', {
//                        "required": true,
//                        //"arabiconly": true,
//                        "maxlength": 255
//                    });
//                    $("input[name*='major']", itt).rules('add', {
//                        //"arabiconly": true,
//                        "maxlength": 255
//                    });
//                    $("input[name*='degree']", itt).rules('add', {
//                        //"arabiconly": true,
//                        "maxlength": 255
//                    });

                    }
                });
            }




            //apply validation on select2 dropdown value change, this only needed for chosen dropdown integration.
            $('.select2me', form3).change(function () {
                form3.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input
            });

            //initialize datepicker
            $('.date-picker').datepicker({
                rtl: App.isRTL(),
                autoclose: true
            });
            $('.date-picker .form-control').change(function () {
                form3.validate().element($(this)); //revalidate the chosen dropdown value and show error or success message for the input 
            })
        }
    }
    return {
        //main function to initiate the module
        init: function () {


            handleRecords();
            repeater();
            initPickers();
            FormValidation();
            Delete();
            if ($(".BarCode_Select").length) {
                BarCode_Select($(".BarCode_Select"));
            }
            if ($(".ItemNumber_Select").length) {
                ItemNumber_Select($(".ItemNumber_Select"));
            }
            if ($(".Item_Select").length) {
                Item_Select($(".Item_Select"));
            }
            if ($(".supplier_Select").length) {
                supplier_Select($(".supplier_Select"));
            }

        }

    };

}();

jQuery(document).ready(function () {
    Stores_Goods_Receipts.init();
});

