var Detection = function () {
    var initPickers = function () {

        //init date pickers
        $('.date-picker').datepicker({
            rtl: App.isRTL(),
            language: Lang.theLang,
            autoclose: true
        });



    };
    var handleRecords = function () {



        var LngArr = {
            "metronicAjaxRequestGeneralError": Lang['Could_not_complete_request_Please_check_your_internet_connection'],
            "sProcessing": Lang['Please_wait'],
            "sLengthMenu": "&nbsp;&nbsp;&nbsp; " + Lang['Show'] + " _MENU_ " + Lang['entries'] + " &nbsp;&nbsp;&nbsp;",
            "sZeroRecords": Lang['No_matching_records_found'],
            "sInfo": Lang['Showing'] + " _START_ " + Lang['To'] + " _END_ " + Lang['of'] + " _TOTAL_ " + Lang['entries'],
            "sInfoEmpty": Lang['Showing'] + " 0 " + Lang['To'] + " 0 " + Lang['of'] + " 0 " + Lang['entries'],
            "sInfoFiltered": "(filtered from _MAX_ total entries)",
            "sInfoPostFix": "",
            "sSearch": "Search:",
            "emptyTable": Lang['No_matching_records_found'],
            "metronicGroupActions": "_TOTAL_ " + Lang['records_selected'] + ":",
            "paginate": {
                "previous": "Prev",
                "next": "Next",
                "last": "Last",
                "first": "First",
                "page": Lang['Page'],
                "pageOf": Lang['of']
            }
        };
        var grid = new Datatable();

        grid.init({
            src: $("#datatable_ajax"),
            onSuccess: function (grid, response) {
                // grid:        grid object
                // response:    json object of server side ajax response
                // execute some code after table records loaded
            },
            onError: function (grid) {
                // execute some code on network or other general error  
            },
            onDataLoad: function (grid) {
                // execute some code on ajax data load
            },
            loadingMessage: Lang.Please_wait,
            dataTable: {// here you can define a typical datatable settings from http://datatables.net/usage/options 
                "language": LngArr,
                // Uncomment below line("dom" parameter) to fix the dropdown overflow issue in the datatable cells. The default datatable layout
                // setup uses scrollable div(table-scrollable) with overflow:auto to enable vertical scroll(see: assets/global/scripts/datatable.js). 
                // So when dropdowns used the scrollable div should be removed. 
                //"dom": "<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'<'table-group-actions pull-right'>>r>t<'row'<'col-md-8 col-sm-12'pli><'col-md-4 col-sm-12'>>",

                "bPaginate": false,
                "bLengthChange": false,
                "bFilter": true,
                "bStateSave": false, // save datatable state(pagination, sort, etc) in cookie.

               "lengthMenu": [
                    [-1],
                    ["All"] // change per page values here
                ],
                "pageLength": -1, // default record count per page

                "ajax": {
                    "url": URLBase + "Stores_Detection/GetData", // ajax source
                },
                "order": [
                    [1, "desc"]
                ], // set first column as a default sort by asc
                "columnDefs": [
                    {
                        'orderable': false,
                        sClass: "text-center",
                        'targets': "_all"
                    },
                ]
            }
        });
        $(document).on('click', '.filter-submit-2', function (e) {
            e.preventDefault();
            grid.UpdateFilterAllDoc(); //لتحديث الفلاتر من كل الجدول
            grid.getthe().submitFilter();

        });

        // handle filter cancel button click
        $(document).on('click', '.filter-cancel', function (e) {
            e.preventDefault();
            grid.getthe().resetFilterAllDocument();
        });

  

        grid.setAjaxParam("customActionType", "group_action");
        // grid.getDataTable().ajax.reload();
        grid.clearAjaxParams();
    }

    return {
        //main function to initiate the module
        init: function () {


            handleRecords();
            initPickers();


        }

    };

}();

jQuery(document).ready(function () {
    Detection.init();
});

