<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Registration'); ?>
            </li>
            <li>
                <?php echo $title; ?>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                            <?php if ($Add) { ?>
                                <a class="btn btn-outline purple" href="<?php echo URL::base() . 'Study_Sections/AE/add'; ?>" > <i class="fa fa-plus"></i> <?php echo Lang::__('add_new'); ?>  </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="2%" class="text-center">
                                        <input type="checkbox" class="group-checkable"> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('term'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('course'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('room'); ?> </th>
                                    <th width="18%" class="text-center"> <?php echo Lang::__('teacher'); ?> </th>
                                    <th width="18%" class="text-center"> <?php echo Lang::__('gender'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td> </td>
                                    <td class="text-center">
                                        <?php $Terms = ORM::factory('Study_Terms')->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control form-filter input-sm select2me" name="term"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Terms as $value) { ?>
                                            <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <?php $Courses = ORM::factory('Study_Courses')->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control form-filter input-sm select2me" name="course"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Courses as $value) { ?>
                                            <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <?php $Rooms = ORM::factory('Study_Rooms')->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control select2me form-filter" name="room"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Rooms as $value) { ?>
                                            <option value="<?php echo $value->id; ?>"><?php echo $value->{'name'}; ?></option>
                                            <?php } ?>
                                        </select> 
                                    </td>
                                    <td class="text-center">
                                        <?php $teachers = Model_Auth_User::GetAllTeachers(); ?>
                                        <select class="form-control select2me form-filter" name="teacher"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($teachers as $value) { ?>
                                            <option value="<?php echo $value->id; ?>" ><?php echo $value->{'name_'.$lang}; ?></option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <?php $General_Genders = ORM::factory('General_Genders')->where('is_active', '=', 1)->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control select2me form-filter" name="gender"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <option value="n"><?php echo Lang::__('Male and Female'); ?></option>
                                            <?php foreach ($General_Genders as $value) { ?>
                                            <option value="<?php echo $value->id; ?>"><?php echo $value->{'name_'.$lang}; ?></option>
                                            <?php } ?>
                                        </select> 
                                    </td>
                       


                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>