<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Stores_Stores'); ?>
            </li>
            <li>
                <?php echo Lang::__('Stocktaking'); ?>
            </li>
            <li class="active"><?php echo $title; ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                         
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_previous_stocktake">
                            <thead>
                                <tr role="row" class="heading">
                                 
                                    <th width="15%" class="text-center"> <?php echo Lang::__('type'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('store'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('categorie'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('stocktake'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('stocktake_date'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('Created_date'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td class="text-center">
                                        <select name="type" class="form-control select2me form-filter" data-placeholder="<?php echo Lang::__('type'); ?>">
                                            <option value=""></option>
                                            <option value="1"><?php echo Lang::__('periodic_stocktaking'); ?></option>
                                            <option value="2"><?php echo Lang::__('continuous_stocktaking'); ?></option>
                                            <option value="3"><?php echo Lang::__('Bpbalance'); ?></option>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <select name="store" class="form-control form-filter select2me" data-placeholder="<?php echo Lang::__('store'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Stores_Stores as $value) { ?>
                                            <option value="<?php echo $value->id; ?>"><?php echo $value->{"name_".$lang}; ?></option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <select id="category" name="category" class="form-control form-filter input-xs select2me" data-placeholder="<?php echo Lang::__('category'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Stores_Categories as $value) { ?>
                                            <option value="<?php echo $value->id; ?>"><?php echo $value->{"name_".$lang}; ?></option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <select name="stocktake" class="select2me form-filter" data-placeholder="<?php echo Lang::__('stocktake'); ?>">
                                            <option value=""></option>
                                            <option value="1"><?php echo Lang::__('Yes Inventory Stocktaked'); ?></option>
                                            <option value="saved"><?php echo Lang::__('Only saved not stocktaked yet'); ?></option>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <div class="input-group date date-picker margin-bottom-5 "  data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="stocktake_date_from" placeholder="<?php echo Lang::__('From'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                        <div class="input-group date date-picker"  data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="stocktake_date_to" placeholder="<?php echo Lang::__('To'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="input-group date date-picker margin-bottom-5 "  data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="created_date_from" placeholder="<?php echo Lang::__('From'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                        <div class="input-group date date-picker"  data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control form-filter input-sm" readonly name="created_date_to" placeholder="<?php echo Lang::__('To'); ?>">
                                            <span class="input-group-btn">
                                                <button class="btn btn-sm default" type="button"><i class="fa fa-calendar"></i></button>
                                            </span>
                                        </div>
                                    </td>


                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>