<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Stores'); ?>
            </li>
            <li>
                <?php echo Lang::__('Stocktaking'); ?>
            </li>
            <li>
                <a class="active"><?php echo $title; ?></a>
            </li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <div class="portlet light bg-inverse">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-plus font-green-haze"></i>
                        <span class="caption-subject bold font-green-haze uppercase"> <?php echo Lang::__('add_new_Stocktaking'); ?> </span>
                        <span class="caption-helper"><?php echo Lang::__($title); ?></span>
                    </div>
                    <div class="actions">
                        <div class="portlet-input input-inline input-medium">
                            
                        </div>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="row form-horizontal">
                        <?php if(in_array($type, array('periodic','bpbalance'))){ ?>
                        <div class="col-md-4">
                            <div class="form-group">
                                <div class="col-md-3 control-label">
                                    <?php echo Lang::__('store'); ?>
                                </div>
                                <div class="col-md-9">
                                    <select id="store" name="store" class="form-control from-filter input-xs select2me" data-placeholder="<?php echo Lang::__('store'); ?>">
                                        <option value=""></option>
                                        <?php foreach ($Stores_Stores as $value) { ?>
                                        <option value="<?php echo $value->id; ?>"><?php echo $value->{"name_".$lang}; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-md-3 control-label">
                                    <?php echo Lang::__('category'); ?>
                                </div>
                                <div class="col-md-9">
                                    <select id="category" name="category" class="form-control from-filter input-xs select2me" data-placeholder="<?php echo Lang::__('category'); ?>">
                                        <option value=""></option>
                                        <?php foreach ($Stores_Categories as $value) { ?>
                                        <option value="<?php echo $value->id; ?>"><?php echo $value->{"name_".$lang}; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        <div class="col-md-3">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <button type="button" class="btn btn-block blue-hoki Stocktaking" t="<?php echo $type; ?>"><?php echo Lang::__('Stocktaking'); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        
    </div>
    <div class="row">
        
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                           
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax" par1="<?php echo $type; ?>" par2="<?php if(isset($Stocktaking_Process)){echo $Stocktaking_Process->id;} ?>" msg1="<?php echo Lang::__('Please specify the store'); ?>">
                            <thead>
        
                                <tr role="row" class="heading">
                                   
                                    <th width="10%" class="text-center"> <?php echo Lang::__('item_number'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('name'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('cost'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('avg_cost'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('Quantity'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('Actual_Quantity'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('dif_in_qty'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('dif_in_cost'); ?> </th>
                                </tr>
                                
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>