<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Human_Resources'); ?>
            </li>
          
            <li>
                <?php echo $title; ?>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                            <?php if ($Add) { ?>
                                <a class="btn btn-outline purple" href="<?php echo URL::base() . 'Hr_Fineswarnings/AE/add'; ?>" > <i class="fa fa-plus"></i> <?php echo Lang::__('add_new'); ?>  </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="2%" class="text-center">
                                        <input type="checkbox" class="group-checkable"> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('employee'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('type'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('month'); ?> </th>
                                    <th width="20%" class="text-center"> <?php echo Lang::__('year'); ?> </th>
                                    <th width="30%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td> </td>
                                    <td class="text-center">
                                        <select name="employee" class="form-control select2me form-filter" data-placeholder="<?php echo Lang::__('employee'); ?>">
                                            <option value=""></option>
                                            <?php
                                            $Employees = ORM::factory('Hr_Employment_Applications')->where('app_status', '=', 1)->where('is_deleted', '=', NULL)->find_all();
                                            foreach ($Employees as $value) { ?>
                                                <option value="<?php echo $value->id; ?>"><?php echo $value->{"name_first_" . $lang} . ' ' . $value->{"name_father_" . $lang}. ' ' . $value->{"name_grandfather_" . $lang} . ' ' . $value->{"name_last_" . $lang}; ?></option>    
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <select name="type" class="form-control select2me form-filter" data-placeholder="<?php echo Lang::__('type'); ?>">
                                            <option value=""></option>
                                            <option value="1"><?php echo Lang::__('Fine'); ?></option>
                                            <option value="2"><?php echo Lang::__('Warning'); ?></option>
                                        </select>
                                    </td>
                                    <td>
                                        <div class="margin-bottom-5">
                                            <input type="text" class="form-control form-filter input-sm" name="month_from" placeholder="<?php echo Lang::__('From'); ?>"/>
                                        </div>
                                        <input type="text" class="form-control form-filter input-sm" name="month_to" placeholder="<?php echo Lang::__('to'); ?>"/>
                                    </td>
                                    <td>
                                        <div class="margin-bottom-5">
                                            <input type="text" class="form-control form-filter input-sm" name="year_from" placeholder="<?php echo Lang::__('From'); ?>"/>
                                        </div>
                                        <input type="text" class="form-control form-filter input-sm" name="year_to" placeholder="<?php echo Lang::__('to'); ?>"/>
                                    </td>


                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>