<div class="page-content">

    <!-- BEGIN BREADCRUMBS -->
    <div class="breadcrumbs">
        <h1><?php echo $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <?php echo Lang::__('System'); ?>
            </li>
            <li>
                <?php echo Lang::__('Financials'); ?>
            </li>
            <li>
                <?php echo $title; ?>
            </li>
            <li class="active"><?php echo Lang::__('view_all'); ?></li>
        </ol>
    </div>
    <!-- END BREADCRUMBS -->
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">
            <!-- Begin: life time stats -->
            <div class="portlet light portlet-fit portlet-datatable bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Showing_and_search_in') . $title; ?></span>
                    </div>
                    <div class="actions">
                        <div class="btn-group btn-group-devided" >
                            <?php if ($Add) { ?>
                                <a class="btn btn-outline purple" href="<?php echo URL::base() . 'Financials_Fees_Courses/AE/add'; ?>" > <i class="fa fa-plus"></i> <?php echo Lang::__('add_new'); ?>  </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="table-container">
                        <table class="table table-striped table-bordered table-hover table-checkable" id="datatable_ajax">
                            <thead>
                                <tr role="row" class="heading">
                                    <th width="2%" class="text-center">
                                        <input type="checkbox" class="group-checkable"> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('student_type'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('level'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('level_price'); ?> </th>
                                    <th width="15%" class="text-center"> <?php echo Lang::__('course'); ?> </th>
                                    <th width="10%" class="text-center"> <?php echo Lang::__('course_price'); ?> </th>
                                    <th width="30%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                </tr>
                                <tr role="row" class="filter">
                                    <td> </td>
                                    <td class="text-center">
                                        <?php $Study_Types = ORM::factory('Study_Types')->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control form-filter input-sm select2me" name="student_type"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Study_Types as $Study_Type) { ?>
                                            <optgroup label="<?php echo $Study_Type->{'name_'.$lang} ?>">
                                                <?php
                                                $Students_Types = $Study_Type->Student_Types->where('is_deleted','=',NULL)->find_all();
                                                foreach ($Students_Types as $Students_Type) { ?>
                                                <option value="<?php echo $Students_Type->id; ?>" ><?php echo $Students_Type->{'name_'.$lang}; ?></option>
                                                <?php } ?>
                                            </optgroup>    
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                    <?php $Study_Degrees = ORM::factory('Study_Degrees')->where('is_deleted', '=', NULL)->find_all(); ?>
                                    <select class="form-control form-filter input-sm select2me" name="level"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                        <option value=""></option>
                                        <?php foreach ($Study_Degrees as $Study_Degree) { ?>
                                        <optgroup label="<?php echo $Study_Degree->{'name_'.$lang} ?>">
                                            <?php
                                            $Levels = $Study_Degree->Levels->where('is_deleted','=',NULL)->find_all();
                                            foreach ($Levels as $level) { ?>
                                            <option value="<?php echo $level->id; ?>" <?php if(isset($Obj) && ($Obj->level == $level->id)){ ?>selected=""<?php } ?>><?php echo $level->{'name_'.$lang}; ?></option>
                                            <?php } ?>
                                        </optgroup>    
                                        <?php } ?>
                                    </select>
                                    </td>
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="level_price"> 
                                    </td>
                                    <td class="text-center">
                                        <?php $Courses = ORM::factory('Study_Courses')->where('is_deleted', '=', NULL)->find_all(); ?>
                                        <select class="form-control form-filter input-sm select2me"  name="course"  data-placeholder="<?php echo Lang::__('select'); ?>">
                                            <option value=""></option>
                                            <?php foreach ($Courses as $value) { ?>
                                        <option value="<?php echo $value->id; ?>" <?php if(isset($Obj) && ($Obj->course == $value->id)){ ?>selected=""<?php } ?>><?php echo $value->course_code.' '.$value->{'name_'.$lang}.' '.$value->course_number; ?></option>
                                            <?php } ?>
                                        </select> 
                                    </td>
                       
                                    <td class="text-center">
                                        <input type="text" class="form-control form-filter input-sm" name="course_price"> 
                                    </td>

                                    <td class="text-center">
                                        <div class="margin-bottom-5">
                                            <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                        </div>
                                        <button class="btn btn-sm red btn-outline filter-cancel">
                                            <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                    </td>
                                </tr>
                            </thead>
                            <tbody> </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- End: life time stats -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>