<div class="content">
    <div class="container pt-sm">
        <div class="row">
            <div class="col-md-12">
                <ul class="breadcrumb">
                    <li><a href="<?php echo URL::base(); ?>"><i class="fa fa-home"></i> <?php echo Lang::__('Home'); ?></a></li>
                    <li class=""><?php echo $title; ?></li>
                    <li class="active font-size-xs"><?php echo $sub_title; ?></li>
                </ul>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <ul class="list list-icons list-dark mt-xlg">
                    <li><?php echo Lang::__('name').': '.$Student_Info->Full_Name_Arabic; ?></li>
                    <li><?php echo Lang::__('gender').': '.$Student_Info->PGender->{'name_'.$lang}; ?></li>
                    <li><?php echo Lang::__('degree').': '.ORM::factory('Study_Degrees', $Student_Info->degree)->{'name_'.$lang}; ?></li>
                    <li><?php echo Lang::__('study_type').': '.ORM::factory('Study_Types', $Student_Info->study_type)->{'name_'.$lang}; ?></li>
                    <li><?php echo Lang::__('student_type').': '.ORM::factory('Students_Types', $Student_Info->student_type)->{'name_'.$lang}; ?></li>
                    <li><?php echo Lang::__('period').': '.Lang::__($StateOfTerm); ?></li>
                    <li><?php echo Lang::__('academic_supervisor').': '.ORM::factory('User', $Student_Info->academic_supervisor)->{'name_'.$lang}; ?></li>
                </ul>
            </div>
            <div class="col-md-6">
                <ul class="list list-icons list-dark mt-xlg">
                    <li><?php echo Lang::__('college').': '.ORM::factory('Study_Majors', $Student_Info->major)->College->{'name_'.$lang}; ?></li>
                    <li><?php echo Lang::__('major').': '.ORM::factory('Study_Majors', $Student_Info->major)->{'name_'.$lang}; ?></li>
                    <?php if($Student_Info->study_type == 1 || $Student_Info->study_type == 3){ ?>
                    <li><?php echo Lang::__('current_level').': '.ORM::factory('Study_Levels', $Student_Info->level)->{'name_'.$lang}; ?></li>
                    <?php } ?>
                    <li><?php echo Lang::__('Academicyear').': '.$Current_Term->Academicyear->{'name_'.$lang}; ?></li>
                    <li><?php echo Lang::__('Term').': '.$Current_Term->{'name_'.$lang}; ?></li>
                    <?php
                        $Study_Terms_Hours = ORM::factory('Study_Terms_Hours')->where('term', '=', $Current_Term->id)->where('degree', '=', $Student_Info->degree)->where('is_deleted', '=', NULL)->find();
                        $min_hours = $Study_Terms_Hours->min_hours;
                        $max_hours = $Study_Terms_Hours->max_hours;

                    ?>
                    <li><?php echo Lang::__('min_hours').': '.$min_hours; ?></li>
                    <li><?php echo Lang::__('max_hours').': '.$max_hours; ?></li>
                </ul>
            </div>
        </div>
        <div class="clearfix"> </div>
        <div class="row">
            <div class="col-md-12">
                <div class="counters">
                    <div class="col-md-4 col-sm-6">
                            <div class="counter counter-with-unit counter-primary">
                                    <strong id="balance" data-to="<?php echo $balance; ?>" data-plugin-options='{"decimals": 2}'><?php echo $balance; ?></strong>
                                    <strong class="font-size-xs"><?php echo Lang::__('RS'); ?></strong>
                                    <label><?php echo Lang::__('balance'); ?></label>
                            </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                            <div class="counter counter-with-unit counter-primary">
                                    <strong id="Current_Term_Cost" data-to="<?php echo $Current_Term_Cost; ?>"><?php echo $Current_Term_Cost; ?></strong>
                                    <strong class="font-size-xs"><?php echo Lang::__('RS'); ?></strong>
                                    <label><?php echo Lang::__('Current_Term_Cost'); ?></label>
                            </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                            <div class="counter counter-with-unit counter-primary">
                                    <strong id="AmountReqToReg" data-to="<?php echo $AmountReqToReg; ?>"><?php echo $AmountReqToReg; ?></strong>
                                    <strong class="font-size-xs"><?php echo Lang::__('RS'); ?></strong>
                                    <label><?php echo Lang::__('AmountReqToReg'); ?></label>
                            </div>
                    </div>
                 
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12" id="Notes"> </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet light portlet-fit portlet-datatable bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="icon-doc font-dark"></i>
                            <span class="caption-subject font-dark sbold uppercase"><?php echo Lang::__('Sections registered on the term').' '.$Current_Term->{'name_'.$lang}; ?></span>
                        </div>
                        <div class="actions">
                            <div class="btn-group btn-group-devided" >
                            </div>
                        </div>
                    </div>
                    <div class="portlet-body">

                        <div class="table-container">
                            <table class="table table-striped table-bordered table-hover table-checkable" id="AllRegSectionsTable">
                                <thead>
                                    <tr role="row" class="heading">
                                        <th width="15%" class="text-center"> <?php echo Lang::__('major'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('course'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('room'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('teacher'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('credit_hours'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('Appointments'); ?> </th>
                                        <th width="30%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                    </tr>
                                    <?php if(false){ ?>
    <!--                                <tr role="row" class="filter">
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <div class="margin-bottom-5">
                                                <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                    <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                            </div>
                                            <button class="btn btn-sm red btn-outline filter-cancel">
                                                <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                        </td>
                                    </tr>-->
                                    <?php } ?>
                                </thead>
                                <tbody> </tbody>
                                <tfoot id="RegSecTfoot" class="hidden">
                                    <tr>
                                        <th colspan="7" id="Tfoot">
                                            
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="clearfix"> </div>
        <div class="row">
            <div class="col-md-12">
                <div class="portlet light portlet-fit portlet-datatable bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="icon-list font-dark"></i>
                            <span class="caption-subject font-dark sbold uppercase"><?php echo ($Student_Info->study_type == 'levels')?Lang::__('Show All Sections For').' '.ORM::factory('Study_Levels', $Student_Info->level)->{'name_'.$lang}:Lang::__('Showing_and_search_in_all_sections_open_on_term') . ' ' . $Current_Term->{'name_' . $lang}; ?></span>
                        </div>
                        <div class="actions">
                            <div class="btn-group btn-group-devided" >
                            </div>
                        </div>
                    </div>
                    <div class="portlet-body">

                        <div class="table-container">
                            <table class="table table-striped table-bordered table-hover table-checkable" id="AllSectionsTable">
                                <thead>
                                    <tr role="row" class="heading">
                                        <th width="15%" class="text-center"> <?php echo Lang::__('major'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('course'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('room'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('teacher'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('credit_hours'); ?> </th>
                                        <th width="15%" class="text-center"> <?php echo Lang::__('Appointments'); ?> </th>
                                        <th width="30%" class="text-center"> <?php echo Lang::__('control'); ?> </th>
                                    </tr>
                                    <?php if(false){ ?>
    <!--                                <tr role="row" class="filter">
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <input type="text" class="form-control form-filter input-sm" name="name"> 
                                        </td>
                                        <td class="text-center">
                                            <div class="margin-bottom-5">
                                                <button class="btn btn-sm green btn-outline filter-submit margin-bottom">
                                                    <i class="fa fa-search"></i> <?php echo Lang::__('Search'); ?></button>
                                            </div>
                                            <button class="btn btn-sm red btn-outline filter-cancel">
                                                <i class="fa fa-times"></i> <?php echo Lang::__('Reset'); ?></button>
                                        </td>
                                    </tr>-->
                                    <?php } ?>
                                </thead>
                                <tbody> </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>
</div>

