<?php

class Model_Students_Notes extends ORM {

    protected $_table_name = 'students_notes';
    protected $_belongs_to = array(
        'Study_Section' => array('model' => 'Study_Sections', 'foreign_key' => 'section_id'),
        'Student_User' => array('model' => 'User', 'foreign_key' => 'student_id'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'student_id' => array(
                array('not_empty'),
            ),
            'section_id' => array(
                array('not_empty'),
            ),
        ));
    }

    public static function TeacherRules($ORM, $Filtered_array = NULL) {
        $RulesJquery = array(
            'details' => array(
                'required' => TRUE,
            ),
        );


        return $RulesJquery;
    }

}
