<?php

class Model_Students_Infractions extends ORM {

    protected $_table_name = 'students_infractions';
    protected $_belongs_to = array(
        'Study_Section' => array('model' => 'Study_Sections', 'foreign_key' => 'section_id'),
        'Student_User' => array('model' => 'User', 'foreign_key' => 'student_id'),
        'Infraction_Type' => array('model' => 'General_Elearning_Students_Infractions', 'foreign_key' => 'infraction_type'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'student_id' => array(
                array('not_empty'),
            ),
            'section_id' => array(
                array('not_empty'),
            ),
        ));
    }

    public static function TeacherRules($ORM, $Filtered_array = NULL) {
        $RulesJquery = array(
            'details' => array(
                //'required' => TRUE,
            ),
            'infraction_type' => array(
                'required' => TRUE,
            ),
        );


        return $RulesJquery;
    }

}
