<?php

class Model_Students_Applications_Steps extends ORM {

    protected $_table_name = 'students_applications_steps';
    protected $_belongs_to = array(
        'Student_Application' => array('model' => 'Students_Applications', 'foreign_key' => 'student_application_id'),
    );
    protected $_has_many = array(
    );

    public function rules() {
        return array(
            'student_application_id' => array(
                array('not_empty'),
                array('Model_Students_Applications_Documents::CheckLoaded', array('Students_Applications', ':field', ':validation', ':value')),
            ),
       
        );
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }
}
