<?php

class Model_Students_Applications extends ORM {

    protected $_table_name = 'students_applications';
    protected $_belongs_to = array(
        'User' => array('model' => 'User', 'foreign_key' => 'student_id'),
        'Rejected_By' => array('model' => 'User', 'foreign_key' => 'rejected_by'),
        'Student_Type' => array('model' => 'Students_Types', 'foreign_key' => 'student_type'),
        'Study_Type' => array('model' => 'Study_Types', 'foreign_key' => 'study_type'),
        'Level' => array('model' => 'Study_Levels', 'foreign_key' => 'level'),
        'Major' => array('model' => 'Study_Majors', 'foreign_key' => 'major'),
        'Study_Degree' => array('model' => 'Study_Degrees', 'foreign_key' => 'degree'),
        'Nationalitie' => array('model' => 'General_Countries', 'foreign_key' => 'Nationality'),
        'HIS_Country' => array('model' => 'General_Countries', 'foreign_key' => 'hs_Country'),
        'HIS_City' => array('model' => 'General_Cities', 'foreign_key' => 'hs_City'),
        'PGender' => array('model' => 'General_Genders', 'foreign_key' => 'Gender'),
        'HS_Certificate_Type' => array('model' => 'General_Hscertypes', 'foreign_key' => 'hs_Certificate_Type'),
        'Parent_realtion' => array('model' => 'General_Sprelations', 'foreign_key' => 'g_relation'),
        'Legalform' => array('model' => 'General_Legalforms', 'foreign_key' => 'Sponsor_Legal_Form'),
        'GEdulevel' => array('model' => 'General_Edulevels', 'foreign_key' => 'g_study_level'),
        'Study_State' => array('model' => 'Students_Study_State', 'foreign_key' => 'S_Type'),
    );
    protected $_has_many = array(
        'Documents' => array('model' => 'Students_Applications_Documents', 'foreign_key' => 'student_application_id'),
        'Steps_Finished' => array('model' => 'Students_Applications_Steps', 'foreign_key' => 'student_application_id'),
        'Stores_Sales_Invoice_Vouchers' => array('model' => 'Stores_Sales_Invoice_Voucher', 'foreign_key' => 'student'),
    );
    protected $_has_one = array(
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'Full_Name_Arabic' => array(
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
            ),
            'Full_Name_English' => array(
                array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
            ),
            'Sponsor_Full_Name_Arabic' => array(
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
            ),
            'Sponsor_Full_Name_English' => array(
                array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
            ),
            'g_Full_Name_Arabic' => array(
                array('Model_Rules::arabiconly', array(':field', ':validation', ':value')),
            ),
            'g_Full_Name_English' => array(
                array('Model_Rules::englishonly', array(':field', ':validation', ':value')),
            ),
            'ID_No' => array(
                array('Model_Students_Applications::CheckID', array(':field', ':validation', ':value', ':model')),
                array('Model_Students_Applications::CheckOtherApp', array(':field', ':validation', ':value', ':model')),
            ),
            'app_type' => array(
                array('Model_Students_Applications::CheckAppType', array(':field', ':validation', ':value')),
            ),
            'student_type' => array(
                array('Model_Students_Applications::CheckStudentType', array(':field', ':validation', ':value', ':model')),
            ),
            'E_Employeed' => array(
                array('Model_Students_Applications::CheckE_Employeed', array(':field', ':validation', ':value')),
            ),
            'E_Eapproval' => array(
                array('Model_Students_Applications::CheckE_Eapproval', array(':field', ':validation', ':value')),
            ),
            'ID_Expiry_Date' => array(
                array('date'),
            ),
            'Date_of_Birth' => array(
                array('date'),
            ),
            'g_email' => array(
                array('email'),
            ),
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();
        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } elseif (!empty($This_ORM['student_id'])) {
            array_push($errors, Lang::__('You can not delete after linking student membership'));
        } elseif (($This_ORM['amount_to_pay'] > 0) && ($This_ORM['amount_paid'] != 1)) {
            array_push($errors, Lang::__('You can not delete request admission after paying the fees'));
        } elseif (!empty($This_ORM['interview_date'])) {
            array_push($errors, Lang::__('You can not delete after metting'));
        } else {
//            foreach ($this->_has_many as $key => $value) {
//                if ($this->$key->count_all() > 0) {
//                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
//                }
//            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteInterview() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();
        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } elseif (!empty($This_ORM['student_id'])) {
            array_push($errors, Lang::__('You can not delete after linking student membership'));
        } elseif (!empty($This_ORM['interview_state'])) {
            array_push($errors, Lang::__('You can not delete an appointment after the amendment to the state or observable'));
        } elseif (!empty($This_ORM['interview_notes'])) {
            array_push($errors, Lang::__('You can not delete an appointment after the amendment to the state or observable'));
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function StepAJqueryRules($ORM_Obj, $ForJqyery = TRUE, $Custom = NULL) {
        $RulesJquery = array(
            'Full_Name_Arabic' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'Full_Name_English' => array(
                'required' => TRUE,
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
            'Place_of_birth' => array(
                'maxlength' => 255,
                'arabic_english_only' => TRUE,
            ),
            'Gender' => array(
                'required' => TRUE,
            ),
            'Nationality' => array(
                'required' => TRUE,
                'number' => TRUE,
            ),
            'ID_No' => array(
                'required' => TRUE,
                'number' => TRUE,
            ),
            'Mobile' => array(
                'required' => TRUE,
                'number' => TRUE,
                'minlength' => 12,
                'maxlength' => 12,
            ),
            'Phone' => array(
                'required' => TRUE,
                'number' => TRUE,
                'minlength' => 12,
                'maxlength' => 12,
            ),
            'Office_Phone' => array(
                'number' => TRUE,
                'minlength' => 12,
                'maxlength' => 12,
            ),
            'Email' => array(
                'required' => TRUE,
                'email' => TRUE
            ),
            'Address' => array(
                'required' => TRUE,
            ),
            'app_type' => array(
                'required' => TRUE,
            ),
            'major' => array(
                'required' => TRUE,
            ),
        );


        if ($ForJqyery) {
            //Some Rules for Query only
            $RulesJquery['bd_day'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['bd_month'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['bd_year'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['bd_day_gregorian'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['bd_month_gregorian'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['bd_year_gregorian'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );

            $RulesJquery['ID_Expiry_day'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['ID_Expiry_month'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['ID_Expiry_year'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['ID_Expiry_day_gregorian'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['ID_Expiry_month_gregorian'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
            $RulesJquery['ID_Expiry_year_gregorian'] = array(
                'required' => TRUE,
                'number' => TRUE,
            );
        }

        if (empty($Custom)) {
            return $RulesJquery;
        } else {
            return array($Custom => $RulesJquery[$Custom]);
        }
    }

    public static function StepBJqueryRules($ORM_Obj, $ForJqyery = TRUE) {
        $RulesJquery = array(
            'Sponsor_Full_Name_Arabic' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'Sponsor_Mobile' => array(
                'required' => TRUE,
                'number' => TRUE,
                'minlength' => 12,
                'maxlength' => 12,
            ),
            'Sponsor_Office_number' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            'Sponsor_Legal_Form' => array(
                'required' => TRUE,
            ),
            'Sponsor_Address' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            'Sponsor_Email' => array(
                'email' => true,
            ),
            'Sponsor_Full_Name_English' => array(
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
        );

        return $RulesJquery;
    }

    public static function StepCJqueryRules($ORM_Obj, $ForJqyery = TRUE) {
        $RulesJquery = array(
            'hs_School_Name' => array(
                'required' => TRUE,
                'maxlength' => 255,
                'arabic_english_only' => TRUE,
            ),
            'hs_Certificate_Type' => array(
                'required' => TRUE,
            ),
            'hs_Qudurat_points' => array(
                'required' => TRUE,
                'number' => TRUE,
                'range' => [0, 100]
            ),
            'hs_Tofel_Points' => array(
                'maxlength' => 255,
                'number' => TRUE,
                'range' => [0, 600]
            ),
            'hs_Country' => array(
                'required' => TRUE,
            ),
            'hs_Graduation_Year' => array(
                'required' => TRUE,
                'date' => TRUE,
            ),
            'hs_Percentage' => array(
                'required' => TRUE,
                'number' => TRUE,
                'range' => [0, 100]
            ),
            'hs_Grade_total' => array(
                'required' => TRUE,
                'number' => TRUE,
                'range' => [100, 10000]
            ),
            'hs_Tahsele_Points' => array(
                'required' => TRUE,
                'number' => TRUE,
                'range' => [0, 100]
            ),
            'hs_City' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
        );
        if ($ORM_Obj->app_type == 'ma') {
            $RulesJquery = array_merge_recursive($RulesJquery, array(
                'ba_College' => array(
                    'required' => TRUE,
                    'maxlength' => 255,
                    'arabic_english_only' => TRUE,
                ),
                'ba_University' => array(
                    'required' => TRUE,
                    'maxlength' => 255,
                    'arabic_english_only' => TRUE,
                ),
                'ba_Major' => array(
                    'required' => TRUE,
                    'maxlength' => 255,
                ),
                'ba_General_Grade' => array(
                    //'number' => TRUE,
                    'maxlength' => 120,
                ),
                'ba_GPA' => array(
                    'required' => TRUE,
                    'number' => TRUE,
                ),
                'ba_Grade_Total' => array(
                    'required' => TRUE,
                ),
                'ba_Graduation_Year' => array(
                    'required' => TRUE,
                    'date' => TRUE,
                ),
            ));
        }


        return $RulesJquery;
    }

    public static function StepDJqueryRules($ORM_Obj, $ForJqyery = TRUE) {
        $RulesJquery = array(
            'g_Full_Name_Arabic' => array(
                'required' => TRUE,
                'arabiconly' => TRUE,
                'maxlength' => 255,
            ),
            'g_Full_Name_English' => array(
                'englishonly' => TRUE,
                'maxlength' => 255,
            ),
            'g_Nationality' => array(
                'required' => TRUE,
            ),
            'g_email' => array(
                'email' => TRUE,
            ),
            'g_job_title' => array(
                'maxlength' => 255,
                'arabic_english_only' => TRUE,
            ),
            'g_Address' => array(
                'required' => TRUE,
                'maxlength' => 255,
            ),
            'g_id_number' => array(
                'required' => TRUE,
                'number' => TRUE,
            ),
            'g_mobile' => array(
                'required' => TRUE,
                'number' => TRUE,
                'minlength' => 12,
                'maxlength' => 12,
            ),
            'g_relation' => array(
                'required' => TRUE,
            ),
            'g_home_number' => array(
                'required' => TRUE,
                'maxlength' => 255,
                'number' => TRUE,
            ),
            'g_employer' => array(
                'required' => TRUE,
                'maxlength' => 255,
                'arabic_english_only' => TRUE,
            ),
            'g_study_level' => array(
                'required' => TRUE,
            ),
        );



        return $RulesJquery;
    }

    public static function StepEJqueryRules($ORM_Obj, $ForJqyery = TRUE) {
        $RulesJquery = array(
            'E_Employeed' => array(
                'required' => TRUE,
                'maxlength' => 4,
            ),
        );
        if ($ORM_Obj->E_Employeed == 'yes' || ($ForJqyery == TRUE)) {
            $RulesJquery = array_merge_recursive($RulesJquery, array(
                'E_Occupation' => array(
                    'required' => TRUE,
                    'maxlength' => 255,
                    'arabic_english_only' => TRUE,
                ),
                'E_Employer' => array(
                    'required' => TRUE,
                    'maxlength' => 255,
                    'arabic_english_only' => TRUE,
                ),
                'E_Experience_level' => array(
                    'required' => TRUE,
                    'number' => TRUE,
                    'range' => [0, 60]
                ),
                'E_Location' => array(
                    'required' => TRUE,
                    'maxlength' => 255,
                    'arabic_english_only' => TRUE,
                ),
                'E_Eapproval' => array(
                    'required' => TRUE,
                    'maxlength' => 5,
                ),
                'E_work_tel_number' => array(
                    'required' => TRUE,
                    'number' => TRUE,
                    'minlength' => 12,
                    'maxlength' => 12,
                ),
                'E_Salary' => array(
                    'maxlength' => 255,
                    'number' => TRUE,
                ),
            ));
        }


        return $RulesJquery;
    }

    public static function StepFJqueryRules($ORM_Obj, $ForJqyery = TRUE) {
        $RulesJquery = array();

        $Documents = ORM::factory('Students_Applications_Documents_Types')->where('student_application_type', '=', $ORM_Obj->app_type)->where('is_deleted', '=', NULL)->find_all();
        foreach ($Documents as $Document_type) {
            $DocumentRel = ORM::factory('Students_Applications_Documents')
                    ->where('student_application_id', '=', $ORM_Obj->id)
                    ->where('document_type', '=', $Document_type->id)
                    ->where('is_deleted', '=', NULL)
                    ->find();
            $RulesJquery['Document' . $Document_type->id] = array(
                'required' => ($Document_type->required == 1 && (!$DocumentRel->loaded())) ? TRUE : FALSE,
                'accept' => str_replace(',', '|', $Document_type->allow_file_ext),
                'filesize' => 1000000 * $Document_type->max_file_size,
            );
        }
        return $RulesJquery;
    }

    /*
     * للتأكد ان نوع الدراسة يتبع نوع الطالب
     */

    public static function CheckStudentType($field, $validation, $value, $model) {
        if (!empty($model->study_type) && !empty($model->Student_Type->Study_Type->id)) {
            if ($model->study_type != $model->Student_Type->Study_Type->id) {
                $validation->error($field, 'StudentType_Not_Belong_Study_Type');
            }
        }
    }

    public static function CheckAppType($field, $validation, $value) {
        if (!in_array($value, array('ba', 'ma'))) {
            $validation->error($field, 'Not_Loaded_In_Database');
        }
    }

    public static function CheckE_Employeed($field, $validation, $value) {
        if (!empty($value)) {
            if (!in_array($value, array('yes', 'no'))) {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function CheckE_Eapproval($field, $validation, $value) {
        if (!empty($value)) {
            if (!in_array($value, array('yes', 'no'))) {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    public static function CheckID($field, $validation, $value, $model) {
        if (!empty($value)) {
            if (empty($model->Nationalitie->GCC)) {
                $data = $validation->data();
                $id = trim($value);
                $type = substr($id, 0, 1);
                if (($type != 2 && $type != 1) || !is_numeric($id) || strlen($id) !== 10) {
                    $validation->error($field, 'Incorrect_Id_NO');
                } else {
                    $sum = NULL;
                    for ($i = 0; $i < 10; $i++) {
                        //echo "  $id <b>"."</b> -";
                        if ($i % 2 == 0) {
                            $ZFOdd = str_pad(( substr($id, $i, 1) * 2), 2, "0", STR_PAD_LEFT);
                            $sum += substr($ZFOdd, 0, 1) + substr($ZFOdd, 1, 1);
                        } else {
                            $sum += substr($id, $i, 1);
                        }
                    }
                    $a = $sum % 10;

                    if ($a !== 0) {
                        $validation->error($field, 'Incorrect_Id_NO');
                    } else {
                        if ($type == 1 && $data['Nationality'] != 1) { // الهوية سعودية والجنسية غير سعودي
                            $validation->error($field, 'conflict_id_with_Nationality');
                        }
                    }
                }
                // $sum%10 ? $validation->error($field, 'Not_Loaded_In_Database') : $type;
                //echo $sum;
                //return $sum % 10 ? false : $type;
//            $R = ORM::factory($model, $value);
//            if ($R->loaded() && ($R->user_groub == 3)) {
//                return TRUE;
//            } else {
//                $validation->error($field, 'Not_Loaded_In_Database');
//            } 
            }
        }
    }

    public static function CheckOtherApp($field, $validation, $value, $model) {

        $data = $validation->data();
        if (!empty($value)) {
            $id = empty($data['id']) ? NULL : $data['id'];
            $Students_Applications = ORM::factory('Students_Applications')
                    ->and_where('id', '!=', $id)
                    ->and_where('ID_No', '=', $value)
                    ->and_where('app_type', '=', $data['app_type'])
                    ->and_where('id_can_order_other', '=', 1)
                    ->find_all();

            $CC = count($Students_Applications);



            if ($CC > 0) {
                $validation->error($field, 'A_request_made_in_advance');
            }
        }
    }

    /*
     * جلب جميع المساقات المطلوبة من الطالب
     */

    public function GetStudentCourses() {
        return $this->Major->Courses->where('is_deleted', '=', NULL)->find_all();
    }

    /*
     * جلب جميع المساقات المطلوبة من الطالب
     */

    public function GetRemainCourses() {

        $AllRegCourses = ORM::factory('Students_Sections')->where('student', '=', $this->User->id)->where('state', '=', 3)->find_all(); //جميع المساقات اللي سجلها الطالب
        $Arr = array(0);
        foreach ($AllRegCourses as $value) {
            array_push($Arr, $value->Section->course);
        }
        return $this->Major->Courses->where('id', 'NOT IN', $Arr)->where('is_deleted', '=', NULL)->find_all();
    }

    /*
     * لفحص هل الطلب خضع لتعديلات من الادارة
     */

    public function App_Affect_by_admins() {

        if ($this->Initial_Approval == 2) {
            return TRUE;
        } elseif (!empty($this->rejected)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    /*
     * اسم الطالب الكامل
     */

    public function FullName($lang) {
        $lang_w = '';
        if ($lang == 'ar') {
            $lang_w = 'Arabic';
        } else {
            $lang_w = 'English';
        }
        return $this->{"Full_Name_" . $lang_w};
    }

    /*
     * هل الطلب قابل للرفض؟
     */

    public function CanRejected() {
        if (!empty($this->rejected)) {
            return FALSE;
        } elseif (empty($this->finished)) {
            return FALSE;
        } elseif (!empty($this->student_id)) {
            return FALSE;
        } elseif ($this->Initial_Approval != 1) {
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
     * انشاء رقم اكاديمي للطالب
     */

    public function GenerateAcadimicNo() {
        $Groub = ORM::factory('Usersgroub', 3); // Student

        $username = $Groub->shortcut . date('y');
        $username .= sprintf("%03s", $this->Major->id);
        $username .= sprintf("%04s", $this->id);
        
        return $username;
    }

}
