<?php

class Model_Stores_Stocktaking_Process extends ORM {

    protected $_table_name = 'stores_stocktaking_process';
    protected $_belongs_to = array(
        'Categorie' => array('model' => 'General_Stores_Categories', 'foreign_key' => 'categorie_id'),
        'Store' => array('model' => 'General_Stores_Stores', 'foreign_key' => 'store_id'),
        'Created_by_User' => array('model' => 'User', 'foreign_key' => 'Created_by'),
        'Stocktake_by_User' => array('model' => 'User', 'foreign_key' => 'stocktake_by'),
    );
    protected $_has_many = array(
        'Elements' => array('model' => 'Stores_Stocktaking_Process_Elements', 'foreign_key' => 'stocktaking_id'),
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'type' => array(
                array('not_empty'),
                array('Model_Stores_Stocktaking_Process::CheckType', array(':field', ':validation', ':value', ':model')),
            ),
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckType($field, $validation, $value, $model) {

        $data = $validation->data();
        if (in_array($value, array(1, 2, 3))) {
            if (in_array($value, array(1, 3)) && empty($model->store_id)) {
                $validation->error('store_id', 'Required');
            }
        } else {
            $validation->error($field, 'Error_Type_Stocktaking');
        }
    }

}
