<?php

class Model_Stores_Sales_Invoice_Vitems extends ORM {

    protected $_table_name = 'stores_sales_invoice_items';
    protected $_belongs_to = array(
        'Stores_Sale_Invoice_Voucher' => array('model' => 'Stores_Sales_Invoice_Voucher', 'foreign_key' => 'voucher_id'),
        'Inventory_Item' => array('model' => 'Stores_Inventory', 'foreign_key' => 'item'),
        'Created_by_User' => array('model' => 'User', 'foreign_key' => 'Created_by'),
        'Last_Update_by_User' => array('model' => 'User', 'foreign_key' => 'last_update_by'),
        'Deleted_By_User' => array('model' => 'User', 'foreign_key' => 'deleted_by'),
    );
    protected $_has_many = array(
        'Elements_Returned' => array('model' => 'Stores_Sales_Elements_Returned', 'foreign_key' => 'element'),
    );

    public function rules() {
        //Check _belongs_to if exist
        $Auto_arr = array();
        $belongs_to = $this->_belongs_to;
        foreach ($belongs_to as $key => $value) {
            if (!empty($value['model']) && !empty($value['foreign_key'])) {
                $Auto_arr[$value['foreign_key']] = array(
                    array('Model_Rules::CheckLoaded', array($value['model'], ':field', ':validation', ':value')),
                );
            }
        }
        //End Check _belongs_to if exist
        return array_merge_recursive($Auto_arr, array(
            'voucher_id' => array(
                array('not_empty'),
            ),
            'item' => array(
                array('not_empty'),
                array('Model_Stores_Sales_Invoice_Vitems::CheckAvaliableity', array(':field', ':validation', ':value', ':model')),

            ),
            'quantity' => array(
                array('numeric'),
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
            'price' => array(
                array('numeric'),
                array('Model_Rules::positive_number', array(':field', ':validation', ':value')),
            ),
        ));
    }

    /*
     * return array of errors
     * or return true if no errors
     */

    public function CheckDeleteRules() {
        $This_ORM = $this->_object; //array_of_this_orm
        $errors = array();

        if ((!$this->_loaded) || !empty($This_ORM['is_deleted'])) {
            array_push($errors, Lang::__('Not_found_the_desired_item'));
        } else {
            foreach ($this->_has_many as $key => $value) {
                if ($this->$key->count_all() > 0) {
                    array_push($errors, Lang::__('Unable_to_deletion_because_it_linked_with') . ' ' . Lang::__($key));
                }
            }
        }

        return (!empty($errors)) ? $errors : TRUE;
    }

    public static function CheckLoaded($model, $field, $validation, $id) {
        if (!empty($id)) {
            $R = ORM::factory($model, $id);
            if ($R->loaded()) {
                return TRUE;
            } else {
                $validation->error($field, 'Not_Loaded_In_Database');
            }
        }
    }

    /*
     * لفحص الكمية المتوفرة 
     */

    public static function CheckAvaliableQuant($model) {
        $Avaaliable_quantity = $model->quantity;

        $Avaaliable_quantity -= $model->CheckReturnedQty();

        return $Avaaliable_quantity;
    }

    /*
     * لفحص الكمية المعادة 
     */

    public function CheckReturnedQty() {
        $Returned_quantity = 0;
        $Elements_Returned = $this->Elements_Returned->where("is_deleted", "=", NULL)->find_all();
        foreach ($Elements_Returned as $value1) {
            $Returned_quantity += $value1->quantity;
        }

        return $Returned_quantity;
    }

    public static function CheckAvaliableity($field, $validation, $value, $model) {

        $CurrentQty = Model_Stores_Inventory::CurrentQty($model->Inventory_Item);

        if (!empty($model->id)) {
            $CurrentQty -= $model->quantity;
        }
        if ($CurrentQty < $model->quantity) {
            $validation->error($field, 'No_quantities_are_available_for_this_item');
        }
    }

}
